% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pldd.R
\name{pldd}
\alias{pldd}
\alias{dpldd}
\alias{ppldd}
\alias{qpldd}
\alias{rpldd}
\title{A Power Log Dagum Distribution}
\usage{
dpldd(x, alpha, beta, theta, log = FALSE)

ppldd(q, alpha, beta, theta, lower.tail = TRUE, log.p = FALSE)

qpldd(p, alpha, beta, theta, lower.tail = TRUE)

rpldd(n, alpha, beta, theta)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{alpha, beta, theta}{are parameters.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are
\eqn{P\left[ X\leq x\right]}, otherwise,\eqn{P\left[ X>x\right] }.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length is taken
to be the number required.}
}
\value{
\code{dpldd} gives the density, \code{ppldd} gives the distribution
function, \code{qpldd} gives the quantile function and \code{rpldd} generates
random deviates.
}
\description{
Density, distribution function, quantile function and random generation for
a Power Log Dagum distribution parameters.
}
\details{
A Power Log Dagum Distribution with parameters \eqn{\alpha}, \eqn{\beta},
\eqn{\theta}, has density given by
\deqn{f\left( x\right) =\alpha
 \left( \beta +\theta \left\vert x\right\vert^{\beta -1}
 \right) e^{-\left( \beta x+sign\left( x\right)
 \left( \theta/\beta \right) \left\vert
   x\right\vert ^{\beta }\right) ~}~\left(1+e^{-\left( \beta x+sign
   \left( x\right)\left( \theta /\beta \right)
   \left\vert x\right\vert ^{\beta }\right) }
   \right) ^{-\left( \alpha +1\right)},}
where
\deqn{x\in \mathbb{R},~\beta \in \mathbb{R},~\alpha >0,~\theta \geq 0}
}
\note{
The distributions hazard function
\deqn{h\left( x\right) =\frac{\alpha
\left( \beta +\theta \left\vert x\right\vert^{\beta -1}
\right) e^{-\left( \beta x+sign\left( x\right) \left( \theta/\beta \right)
\left\vert x\right\vert ^{\beta }\right) }\left( 1+e^{-\left(\beta x+sign
\left( x\right) \left( \theta /\beta \right) \left\vert x
\right\vert ^{\beta }\right) }\right) ^{-\left(\alpha +1\right) }}
        {1-\left( 1+e^{-\left( \beta x+sign\left( x\right) \left( \theta /
\beta \right) \left\vert x\right\vert ^{\beta }\right) }
\right) ^{-\alpha }} .}
}
\examples{
library(new.dist)
dpldd(1, alpha=2, beta=3, theta=4)
ppldd(1,alpha=2,beta=3,theta=4)
qpldd(.8,alpha=2,beta=3,theta=4)
rpldd(10,alpha=2,beta=3,theta=4)
}
\references{
Bakouch, H. S., Khan, M. N., Hussain, T. ve Chesneau, C., 2019,
\emph{A power log-Dagum distribution: estimation and applications}, Journal of
Applied Statistics, 46 (5), 874-892.
}
