% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mix.R
\docType{methods}
\name{mix}
\alias{mix}
\alias{mix-method}
\alias{mix,matrix,matrix-method}
\alias{mix,dist,dist-method}
\title{Mixed-Mode Analysis}
\usage{
mix(x, y, ...)

\S4method{mix}{matrix,matrix}(x, y, lambda = 1, ...)

\S4method{mix}{dist,dist}(x, y, mu = 0.5)
}
\arguments{
\item{x}{A \code{\link{matrix}} of chemical compositional data or a
\link[stats:dist]{dissimilarity matrix} for these chemical compositional data.}

\item{y}{A \code{\link{matrix}} of coded mineralogical binary data or a
\link[stats:dist]{dissimilarity matrix} for these mineralogical data.}

\item{...}{Extra parameters to be passed to \code{\link[cluster:daisy]{cluster::daisy()}}.}

\item{lambda}{A length-one \code{\link{numeric}} vector giving a weighting factor.}

\item{mu}{A length-one \code{\link{numeric}} vector that lies between 0 and 1 giving
the mixing parameter.}
}
\value{
A \link[stats:dist]{stats::dist} object.
}
\description{
Mixes chemical and petrographic matrices.
}
\section{Methods (by class)}{
\itemize{
\item \code{mix(x = matrix, y = matrix)}: First approach of mixed-mode analysis.

\item \code{mix(x = dist, y = dist)}: Second approach of mixed-mode analysis.

}}
\note{
\strong{Experimental.}
}
\examples{
\donttest{
## Prepare chemical data
data("chemistry")
major <- c("Fe2O3", "Al2O3", "MnO", "P2O5", "TiO2", "MgO", "CaO", "Na2O", "K2O", "SiO2")
chem <- chemistry[-1, major]

## Prepare petrographic data
data("petrography")
petro <- petrography[-c(7, 8), -1]
petro <- cdt(petro) # Get the complete disjunctive table

## First approach
mix1 <- mix(as.matrix(chem), as.matrix(petro), lambda = 2)
mds1 <- stats::cmdscale(mix1) # Multi-Dimensional Scaling
plot(mds1)
}
}
\references{
Baxter, M. J., Beardah, C. C., Papageorgiou, I., Cau, M. A., Day, P. M. &
Kilikoglou, V. (2008). On Statistical Approaches to the Study of Ceramic
Artefacts Using Geochemical and Petrographic Data. \emph{Archaeometry}, 50(1):
142-157. \doi{10.1111/j.1475-4754.2007.00359.x}.

Beardah, C. C., Baxter, M. J., Papageorgiou, I. & Cau, M. A. (2003).
"Mixed-Mode" Approaches to the Grouping of Ceramic Artefacts Using S-Plus.
In M. Doerr and A. Sarris, \emph{The Digital Heritage of Archaeology}, p. 261-266.
Athens: Archive of Monuments and Publications, Hellenic Ministry of Culture.

Gower, J. C. (1971). A general coefficient of similarity and some of its
properties. \emph{Biometrics}, 27(4):857-874. \doi{10.2307/2528823}.
}
\author{
N. Frerebeau
}
\concept{sourcing methods}
