% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/chemistry.R
\docType{methods}
\name{chemistry}
\alias{chemistry}
\alias{is_element_major}
\alias{is_element_major-method}
\alias{is_element_minor}
\alias{is_element_minor-method}
\alias{is_element_trace}
\alias{is_element_trace-method}
\alias{is_oxide}
\alias{is_oxide-method}
\alias{is_oxide,character-method}
\alias{is_oxide,CompositionMatrix-method}
\alias{is_element_major,CompositionMatrix-method}
\alias{is_element_minor,CompositionMatrix-method}
\alias{is_element_trace,CompositionMatrix-method}
\title{Chemical Elements and Oxides}
\usage{
is_element_major(object, ...)

is_element_minor(object, ...)

is_element_trace(object, ...)

is_oxide(object, ...)

\S4method{is_oxide}{character}(object)

\S4method{is_oxide}{CompositionMatrix}(object)

\S4method{is_element_major}{CompositionMatrix}(object, min = 1/100, max = Inf)

\S4method{is_element_minor}{CompositionMatrix}(object, min = 0.1/100, max = 1/100)

\S4method{is_element_trace}{CompositionMatrix}(object, min = -Inf, max = 0.1/100)
}
\arguments{
\item{object}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}

\item{min}{A length-one \code{\link{numeric}} vector specifying the lower bound for
element identification.}

\item{max}{A length-one \code{\link{numeric}} vector specifying the upper bound for
element identification.}
}
\value{
A \code{\link{logical}} vector.
}
\description{
Identify oxides and major, minor and traces elements in a compositional data
matrix.
}
\details{
There is no definite classification of what are the major, minor and trace
elements are. By default, the following rule of thumb is used:
\describe{
\item{major elements}{The major elements are those that define the material
under study. Major elements usually have concentrations of above 1\%.}
\item{minor elements}{Minor elements usually have concentrations between
1\% and 0.1\%}
\item{trace elements}{Trace elements usually have concentrations of less
than 0.1\%.}
}
}
\note{
\code{is_oxide()} uses a regular expression (it does not check if elements exist
or if stoichiometry is valid).
}
\examples{
## Data from Day et al. 2011
data("kommos", package = "folio") # Coerce to compositional data
kommos <- remove_NA(kommos, margin = 1) # Remove cases with missing values
coda <- as_composition(kommos, groups = 1) # Use ceramic types for grouping

is_element_major(coda)
is_element_minor(coda)
is_element_trace(coda)

is_oxide(coda)
}
\author{
N. Frerebeau
}
\concept{tools}
