% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/outliers.R
\docType{methods}
\name{plot_outlier}
\alias{plot_outlier}
\alias{plot,OutlierIndex,missing-method}
\title{Plot Outliers}
\usage{
\S4method{plot}{OutlierIndex,missing}(
  x,
  ...,
  type = c("dotchart", "distance"),
  robust = TRUE,
  symbols = c(16, 1, 3),
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  panel.first = NULL,
  panel.last = NULL,
  legend = list(x = "topleft")
)
}
\arguments{
\item{x}{An \code{\linkS4class{OutlierIndex}} object.}

\item{...}{Further parameters to be passed to \code{\link[graphics:points]{graphics::points()}}.}

\item{type}{A \code{\link{character}} string specifying the type of plot that should be
made. It must be one of "\code{dotchart}" or "\code{distance}".
Any unambiguous substring can be given.}

\item{robust}{A \code{\link{logical}} scalar: should robust Mahalanobis distances be
displayed? Only used if \code{type} is "\code{dotchart}".}

\item{symbols}{A lenth-three vector of symbol specification for non-outliers
and outliers (resp.).}

\item{xlim}{A length-two \code{\link{numeric}} vector giving the x limits of the plot.
The default value, \code{NULL}, indicates that the range of the
\link[=is.finite]{finite} values to be plotted should be used.}

\item{ylim}{A length-two \code{\link{numeric}} vector giving the y limits of the plot.
The default value, \code{NULL}, indicates that the range of the
\link[=is.finite]{finite} values to be plotted should be used.}

\item{xlab, ylab}{A \code{\link{character}} vector giving the x and y axis labels.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x
and y axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{panel.first}{An an \code{expression} to be evaluated after the plot axes are
set up but before any plotting takes place. This can be useful for drawing
background grids.}

\item{panel.last}{An \code{expression} to be evaluated after plotting has taken
place but before the axes, title and box are added.}

\item{legend}{A \code{\link{list}} of additional arguments to be passed to
\code{\link[graphics:legend]{graphics::legend()}}; names of the list are used as argument names.
If \code{NULL}, no legend is displayed.}
}
\value{
\code{plot()} is called for its side-effects: is results in a graphic being
displayed (invisibly return \code{x}).
}
\description{
Plot Outliers
}
\examples{
## Data from Day et al. 2011
data("kommos", package = "folio") # Coerce to compositional data
kommos <- remove_NA(kommos, margin = 1) # Remove cases with missing values
coda <- as_composition(kommos, parts = 3:17, groups = 1)

## Detect outliers
out <- detect_outlier(coda)

plot(out, type = "dotchart")
plot(out, type = "distance")

## Detect outliers according to CJ
ref <- group_extract(coda, "CJ")
out <- detect_outlier(coda, reference = ref, method = "mcd")
plot(out, type = "dotchart")
}
\references{
Filzmoser, P., Garrett, R. G. & Reimann, C. (2005). Multivariate outlier
detection in exploration geochemistry. \emph{Computers & Geosciences},
31(5), 579-587. \doi{10.1016/j.cageo.2004.11.013}.

Filzmoser, P. & Hron, K. (2008). Outlier Detection for Compositional Data
Using Robust Methods. \emph{Mathematical Geosciences}, 40(3), 233-248.
\doi{10.1007/s11004-007-9141-5}.

Filzmoser, P., Hron, K. & Reimann, C. (2012). Interpretation of multivariate
outliers for compositional data. \emph{Computers & Geosciences}, 39, 77-85.
\doi{10.1016/j.cageo.2011.06.014}.
}
\seealso{
Other outlier detection methods: 
\code{\link{detect_outlier}()}
}
\author{
N. Frerebeau
}
\concept{outlier detection methods}
