% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_date.R
\name{get_current_week}
\alias{get_current_week}
\title{Get Current Week}
\usage{
get_current_week(use_date = FALSE)
}
\arguments{
\item{use_date}{a logical to determine whether to use date-based heuristics to
determine current week, default FALSE (i.e. uses schedule file)}
}
\value{
current nfl regular season week as a numeric
}
\description{
A helper function that returns the upcoming NFL regular season week based on either
the nflverse schedules file (as found in \code{load_schedules()})
or some date-based heuristics (number of weeks since the first Monday of September)
}
\examples{
{
  \donttest{
    try({ # schedules file as per default requires online access
    get_current_week()
    })
  }
  # using the date method works offline
  get_current_week(use_date = TRUE)
}

}
\seealso{
Other Date utils: 
\code{\link{most_recent_season}()}
}
\concept{Date utils}
