% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiread.r
\name{multiread}
\alias{multiread}
\title{Multiread}
\usage{
multiread(path = ".", extension = "txt", recursive = FALSE,
  ignore.case = FALSE, prune.empty = TRUE, pathnames = TRUE)
}
\arguments{
\item{path}{The base file path to search.}

\item{extension}{An extension or the "*" wildcard (for everything).  For example, 
to read in files ending \code{.txt}, you could specify 
\code{extension="txt"}.  For the purposes of this function,
each of \code{*.txt}, \code{*txt}, \code{.txt}, and \code{txt}
are treated the same.}

\item{recursive}{Logical; should the search include all subdirectories?}

\item{ignore.case}{Logical; should case be ignored in the extension? For example, if
\code{TRUE}, then \code{.r} and \code{.R} files are treated the
same.}

\item{prune.empty}{Logical; should empty files be removed from the returned list?}

\item{pathnames}{Logical; should the full path be included in the names of the
returned list.}
}
\value{
A named list of strings, where the names are the file names.
}
\description{
Read in a collection of text files.
}
\details{
The \code{extension} argument is not a general regular
expression pattern, but a simplified pattern.  For example,
the pattern \code{*.txt} is really equivalent to 
\code{*[.]txt$} as a regular expression.  If you need more
complicated patterns, you should directly use the \code{dir()}
function.
}
\examples{
\dontrun{
path <- system.file(package="ngram")

### Read all files in the base path
multiread(path, extension="*")

### Read all .r/.R files recursively (warning: lots of text)
multiread(path, extension="r", recursive=TRUE, ignore.case=TRUE)

}

}
\keyword{Utility}
