% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.r
\name{preprocess}
\alias{preprocess}
\title{Basic Text Preprocessor}
\usage{
preprocess(x, case = "lower", remove.punct = FALSE,
  remove.numbers = FALSE, fix.spacing = TRUE)
}
\arguments{
\item{x}{Input text.}

\item{case}{Option to change the case of the text. Value should be "upper",
"lower", or NULL (no change).}

\item{remove.punct}{Logical; should punctuation be removed?}

\item{remove.numbers}{Logical; should numbers be removed?}

\item{fix.spacing}{Logical; should multi/trailing spaces be collapsed/removed.}
}
\value{
\code{concat()} returns
}
\description{
A simple text preprocessor for use with the \code{ngram()} function.
}
\details{
The input text \code{x} must already be in the correct form for
\code{ngram()}, i.e., a single string (character vector of length 1).

The \code{case} argument can take 3 possible values: \code{NULL}, in which
case nothing is done, or \code{lower} or \code{upper}, wherein the case of
the input text will be made lower/upper case, repesctively.
}
\examples{
library(ngram)

x <- "Watch  out    for snakes!  111"
preprocess(x)
preprocess(x, remove.punct=TRUE, remove.numbers=TRUE)

}
\keyword{Preprocessing}
