% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{nhd_query}
\alias{nhd_query}
\title{Select NHD features clipped by a circular buffer a coordinate pair}
\usage{
nhd_query(lon, lat, dsn, buffer_dist = 0.05)
}
\arguments{
\item{lon}{numeric longitude}

\item{lat}{numeric latitude}

\item{dsn}{character data source}

\item{buffer_dist}{numeric buffer in units of coordinate degrees}
}
\description{
Select NHD features clipped by a circular buffer a coordinate pair
}
\examples{
\dontrun{
wk <- wikilake::lake_wiki("Worden Pond")
qry <- nhd_query(wk$Lon, wk$Lat, dsn = c("NHDWaterbody", "NHDFlowline"))

plot(sf::st_geometry(qry$sp$NHDWaterbody), col = "blue")
plot(sf::st_geometry(qry$sp$NHDFlowline), col = "cyan", add = TRUE)
plot(qry$pnt, col = "red", pch = 19, add = TRUE)
axis(1); axis(2)
}
}
