% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_network.R
\name{get_UM}
\alias{get_UM}
\title{Navigate Upstream Mainstem}
\usage{
get_UM(network, comid, distance = NULL)
}
\arguments{
\item{network}{data.frame NHDPlus flowlines including at a minimum:
COMID,Pathlength, LevelPathI, UpHydroseq, and Hydroseq.}

\item{comid}{integer identifier to start navigating from.}

\item{distance}{numeric distance in km to limit how many COMIDs are
returned. The COMID that exceeds the distance specified is returned.}
}
\value{
integer vector of all COMIDs upstream of the starting COMID
along the mainstem.
}
\description{
Traverse NHDPlus network upstream main stem
}
\examples{
library(sf)
sample_flines <- read_sf(system.file("extdata",
                                     "petapsco_flowlines.gpkg",
                                     package = "nhdplusTools"))
plot(sample_flines$geom)
start_COMID <- 11690196
UM_COMIDs <- get_UM(sample_flines, start_COMID)
plot(dplyr::filter(sample_flines, COMID \%in\% UM_COMIDs)$geom,
     col = "red", add = TRUE, lwd = 3)

UM_COMIDs <- get_UM(sample_flines, start_COMID, distance = 50)
plot(dplyr::filter(sample_flines, COMID \%in\% UM_COMIDs)$geom,
     col = "blue", add = TRUE, lwd = 2)

}
