% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_network.R
\name{navigate_network}
\alias{navigate_network}
\title{Navigate Network}
\usage{
navigate_network(
  start,
  mode = "UM",
  network = NULL,
  output = "flowlines",
  distance_km = 10,
  trim_start = FALSE,
  trim_stop = FALSE,
  trim_tolerance = 5
)
}
\arguments{
\item{start}{list, integer, sf, or sfc if list must be a valid NLDI feature
if integer must be a valid comid. If sf, must contain a "comid" field.}

\item{mode}{character chosen from c(UM, DM, UT, or DD)}

\item{network}{sf should be compatible with network navigation functions
If NULL, network will be derived from requests to the NLDI}

\item{output}{character flowline or a valid NLDI data source}

\item{distance_km}{numeric distance to navigate in km}

\item{trim_start}{logical should start be trimmed or include entire catchment?}

\item{trim_stop}{logical should stop(s) be trimmed or include entire catchment(s)?
# Not supported}

\item{trim_tolerance}{numeric from 0 to 100 percent of flowline length. If amount
to trim is less than this tolerance, no trim will be applied.}
}
\description{
Provides a full feature network navigation function that
will work with local or web service data. Parameter details provide
context.
}
\examples{

\donttest{
navigate_network(list(featureSource = "nwissite", featureID = "USGS-06287800"),
                "UM",
                output = "flowlines",
                trim_start = TRUE)
}

source(system.file("extdata", "walker_data.R", package = "nhdplusTools"))
hydro_location <- list(comid = 5329339,
                      reachcode = "18050005000078",
                       reach_meas = 30)

hydro_location <- sf::st_sf(
  hydro_location,
  geom = nhdplusTools::get_hydro_location(data.frame(hydro_location),
                                          walker_flowline))

net <- navigate_network(hydro_location,
                       mode = "DM", network = walker_flowline,
                       trim_start = TRUE, distance_km = 20)

plot(sf::st_geometry(walker_flowline))
plot(sf::st_geometry(hydro_location), add = TRUE)
plot(sf::st_geometry(net), add = TRUE, col = "blue", lwd = 2)

}
