% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloading_tools.R
\name{download_nhdplusv2}
\alias{download_nhdplusv2}
\title{Download seamless National Hydrography Dataset Version 2 (NHDPlusV2)}
\usage{
download_nhdplusv2(
  outdir,
  url = paste0("https://dmap-data-commons-ow.s3.amazonaws.com/NHDPlusV21/",
    "Data/NationalData/NHDPlusV21_NationalData_Seamless", "_Geodatabase_Lower48_07.7z"),
  progress = TRUE
)
}
\arguments{
\item{outdir}{The folder path where data should be downloaded and extracted}

\item{url}{the location of the online resource}

\item{progress}{boolean display download progress?}
}
\value{
character path to the local geodatabase
}
\description{
This function downloads and decompresses staged seamless NHDPlusV2 data.
The following requirements are needed: p7zip (MacOS), 7zip (windows) Please see:
https://www.epa.gov/waterdata/get-nhdplus-national-hydrography-dataset-plus-data
for more information and metadata about this data.

Default downloads lower-48 only. See examples for islands. No Alaska data
are available.
}
\examples{
\dontrun{
  download_nhdplusV2("./data/nhd/")

  download_nhdplusv2(outdir = "./inst/",
      url = paste0("https://dmap-data-commons-ow.s3.amazonaws.com/NHDPlusV21/",
                   "Data/NationalData/NHDPlusV21_NationalData_Seamless",
                   "_Geodatabase_HI_PR_VI_PI_03.7z"))
}
}
