% Generated by roxygen2 (4.0.1): do not edit by hand
\name{niw.coeffs}
\alias{niw.coeffs}
\title{Posterior coefficients of the Normal-Inverse-Wishart distribution with its conjugate prior.}
\usage{
niw.coeffs(X, lambda, kappa, Psi, nu)
}
\arguments{
\item{X}{a data matrix with observations along the rows.}

\item{lambda}{location parameter. See Details.}

\item{kappa}{scale parameter. Defaults to \code{kappa = 0}.  See Details.}

\item{Psi}{scale matrix. Defaults to \code{Psi = 0}.  See Details.}

\item{nu}{degrees of freedom. Defaults to \code{nu = ncol(X)+1}.  See Details.}
}
\value{
Returns a list with elements \code{lambda}, \code{kappa}, \code{Psi}, \code{nu} corresponding to the coefficients of the NIW
posterior distribution \eqn{p(\mu, \Sigma | X)}.
}
\description{
Given iid \eqn{d}-dimensional niche indicators \eqn{X = (X_1,\ldots,X_N)} with \eqn{X_i \sim N(\mu, \Sigma)},
this function calculates the coefficients of the Normal-Inverse-Wishart (NIW) posterior
\eqn{p(\mu, \Sigma | X)} for a conjugate NIW prior.  Together with \code{\link{niw.mom}},
this can be used to rapidly compute the point estimates \eqn{E[\mu | X]} and \eqn{E[\Sigma | X]}.
}
\details{
The NIW distribution \eqn{p(\mu, \Sigma | \lambda, \kappa, \Psi, \nu)} is defined as
\deqn{\Sigma \sim W^{-1}(\Psi, \nu), \quad \mu | \Sigma \sim N(\lambda, \Sigma/\kappa).}
The default value \code{kappa = 0} uses the Lebesque prior on \eqn{\mu}: \eqn{p(\mu) \propto 1}.
The default value \code{Psi = 0} uses the scale-invariant prior on \eqn{\Sigma}: \eqn{p(\Sigma) \propto |\Sigma|^{-(\nu+d+1)/2}}.
The default value \code{nu = ncol(X)+1} for \code{kappa = 0} and \code{Psi = 0} makes \eqn{E[\mu|X]=\code{colMeans(X)}} and \eqn{E[\Sigma | X]=\code{var(X)}}.
}
\examples{
# NIW prior coefficients
d <- 3
lambda <- rnorm(d)
kappa <- 5
Psi <- crossprod(matrix(rnorm(d^2), d, d))
nu <- 10

# data
data(fish)
X <- fish[fish$species == "ARCS",2:4]

# NIW posterior coefficients
post.coef <- niw.coeffs(X, lambda, kappa, Psi, nu)

# compare
mu.mean <- niw.mom(post.coef$lambda, post.coef$kappa, post.coef$Psi, post.coef$nu)$mu$mean
mu.est <- rbind(prior = niw.mom(lambda, kappa, Psi, nu)$mu$mean,
               data = colMeans(X),
               post = mu.mean)
round(mu.est, 2)
}
\seealso{
\code{\link{rniw}}, \code{\link{niw.mom}}, \code{\link{niw.post}}.
}

