% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_helpers.R
\name{nichevol_legend}
\alias{nichevol_legend}
\title{Legends for niche evolution labels in phylogenetic trees}
\usage{
nichevol_legend(position, ancestor_line = FALSE,
  ancestor_legend = c("Uncertain", "Present"),
  evol_legend = c("No change", "Retraction", "Expansion"),
  ancestor_col = c("#d9d9d9", "#252525"),
  evol_col = c("#b2df8a", "#984ea3", "#4daf4a"),
  pch = 22, pt.cex = 2.2, lty = 1, lwd = 1, cex = 1, bty = "n", ...)
}
\arguments{
\item{position}{(character or numeric) position of legend. If character,
part of the plot (e.g., "topleft"), see \code{\link[graphics]{legend}}. If
numeric, vector of two values indicating x and y position (e.g., c(0.1, 6)).}

\item{ancestor_line}{whether or not ancestor line was plotted.
Default = FALSE.}

\item{ancestor_legend}{(character) vector of length = two indicating the text
to identify environments with uncertain presence and true presence of the
species. Default = c("Uncertain", "Present").}

\item{evol_legend}{(character) vector of length = three indicating the text
to identify environments where niches have not changed, have retracted or
expanded. Default = c("No change", "Retraction", "Expansion").}

\item{ancestor_col}{vector of two colors to represent what is indicated in
\code{ancestor_legend}. Default = c("#d9d9d9", "#252525").}

\item{evol_col}{vector of three colors to represent what is indicated in
\code{evol_legend}. Default = c("#b2df8a", "#984ea3", "#4daf4a").}

\item{pch}{point type as in \code{\link[graphics]{points}}. Default = 22.}

\item{pt.cex}{size of symbol (points). Default = 2.2.}

\item{lty}{line type see \code{\link[graphics]{par}}. Default = 1.}

\item{lwd}{line width see \code{\link[graphics]{par}}. Default = 1.}

\item{cex}{size of all elements in legend see \code{\link[graphics]{par}}.
Default = 1.}

\item{bty}{legend border type. Default = "n".}

\item{...}{Other arguments from function \code{\link[graphics]{legend}} other
than the ones described above.}
}
\description{
Legends for niche evolution labels in phylogenetic trees
}
\examples{
# a simple tree
data("tree5", package = "nichevol")

# a matrix of niche charactes (1 = present, 0 = absent, ? = unknown)
dataTable <- cbind("241" = rep("1", length(tree5$tip.label)),
                   "242" = rep("1", length(tree5$tip.label)),
                   "243" = c("1", "1", "0", "0", "0"),
                   "244" = c("1", "1", "0", "0", "0"),
                   "245" = c("1", "?", "0", "0", "0"))
rownames(dataTable) <- tree5$tip.label

# list with two objects (tree and character table)
treeWdata <- geiger::treedata(tree5, dataTable)

# Maximum parsimony reconstruction
rec_tab <- smooth_rec(bin_par_rec(treeWdata))

# plotting and adding labels and legend
ape::plot.phylo(tree5, label.offset = 0.04)
nichevol_labels(tree5, rec_tab, height = 0.6)
nichevol_legend(position = "bottomleft", cex = 0.7)
}
