% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in Rtmp9wH6ZH/file2ef7725fe91c
\name{values}
\alias{values}
\alias{values<-}
\title{Access or set values for a set of nodes in a model}
\usage{
values(model, nodes)

values(model, nodes) <- value
}
\arguments{
\item{model}{a NIMBLE model object, either compiled or uncompiled}

\item{nodes}{a vector of node names, allowing index blocks that will be expanded}

\item{value}{value to set the node(s) to}
}
\value{
A vector of values concatenated from the provided nodes in the model
}
\description{
Get or set values for a set of nodes in a model
}
\details{
Access or set values for a set of nodes in a NIMBLE model.

Calling \code{values(model, nodes)} returns a vector of the concatenation of values from the nodes requested
\code{P <- values(model, nodes)} is a newer syntax for \code{getValues(P, model, values)}, which still works and modifies P in the calling environment.

Calling \code{values(model, nodes) <- P} sets the value of the nodes in the model, in sequential order from the vector P.

In both uses, when requested nodes are from matrices or arrays, the values will be handled following column-wise order.

The older function \code{getValues(P, model, nodes)} is equivalent to \code{P <- values(model, nodes)}, and the older function \code{setValues(P, model, nodes)} is equivalent to \code{values(model, nodes) <- P}


These functions work in R and in NIMBLE run-time code that can be compiled.
}
\author{
NIMBLE development team
}

