% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in RtmpK6dyXN/file1e0943c797ed
\name{updateMCMCcomparisonWithHighOrderESS}
\alias{updateMCMCcomparisonWithHighOrderESS}
\title{Re-estimate effective sample size from results of compareMCMCs}
\usage{
updateMCMCcomparisonWithHighOrderESS(mcmcResults, logVars = "",
  includeBurninTime = TRUE, StanESS = FALSE)
}
\arguments{
\item{mcmcResults}{An object returned by \code{compareMCMCs}}

\item{logVars}{Names of any variables for which ESS should be calculated after log transformation.  This is useful if different methods use models in which the same variance component is set up either as standard deviation, variance, or precision.  Calculating ESS on a log scale arguably makes these more comparable than converting one into another for comparisons.}

\item{includeBurninTime}{(default TRUE) If TRUE, the time spent on burnin (or warmup) is included in the denominator of MCMC efficiency. If false, only the time spent generating samples that are used for estimation of ESS is included.}

\item{StanESS}{(default FALSE) If FALSE, ESS will be estimated by the same method as in the code package, but allowing higher-order auto-regressive models to be considered.  If TRUE, the method in Stan will be used via the \code{monitor} function in package rstan.}
}
\value{
A list of the same format as \code{mcmcResults}
}
\description{
By default the effective sample sizes (ESS) (and MCMC efficiencies) are estimated from the coda package.  This function estimates them either using the same method as coda but allowing higher-order AR models or using the method provided in Stan via package rstan.
}

