% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/filtering_auxiliary.R
\name{buildAuxiliaryFilter}
\alias{buildAuxiliaryFilter}
\title{Create an auxiliary particle filter algorithm to estimate log-likelihood.}
\usage{
buildAuxiliaryFilter(model, nodes, control = list())
}
\arguments{
\item{model}{A NIMBLE model object, typically representing a state space model or a hidden Markov model}

\item{nodes}{A character vector specifying the latent model nodes over which the particle filter will stochastically integrate to estimate the log-likelihood function}

\item{control}{A list specifying different control options for the particle filter.  Options are described in the details section below.}
}
\description{
Create an auxiliary particle filter algorithm for a given NIMBLE state space model.
}
\details{
The \code{control} argument can be specified as follows.
\describe{
\item{lookahead}{The lookahead function used to calculate auxiliary weights.  Can choose between \code{'mean'} and \code{'simulate'}.
 Defaults to \code{'simulate'}.}
 \item{saveAll}{Indicates whether to save state samples for all time points (\code{TRUE}), or only for the most recent time point (\code{FALSE})}
 \item{smoothing}{Decides whether to save smoothed estimates of latent states, i.e., samples from f(x[1:t]|y[1:t]) if \code{smoothing = TRUE}, or instead to save filtered samples from f(x[t]|y[1:t]) if \code{smoothing = FALSE}. \code{smoothing = TRUE} only works if \code{saveAll = TRUE}.}
 \item{timeIndex}{An integer used to manually specify which dimension of the latent state variable indexes time. This need only be set if the number of time points is less than or equal to the size of the latent state at each time point.}
 \item{initModel}{A logical value indicating whether to initialize the model before running the filtering algorithm.  Defaults to TRUE.}
 }

The auxiliary particle filter modifies the bootstrap filter (\code{\link{buildBootstrapFilter}})
by adding a lookahead step to the algorithm: before propagating particles from one time
point to the next via the transition equation, the auxiliary filter calculates a weight
for each pre-propogated particle by predicting how well the particle will agree with the
next data point.  These pre-weights are used to conduct an initial resampling step before
propagation.

 The resulting specialized particle filter algorthm will accept a
 single integer argument (\code{m}, default 10,000), which specifies the number
 of random \'particles\' to use for estimating the log-likelihood.  The algorithm
 returns the estimated log-likelihood value, and saves
 unequally weighted samples from the posterior distribution of the latent
 states in the \code{mvWSamples} modelValues object, with corresponding logged weights in \code{mvWSamples['wts',]}.
 An equally weighted sample from the posterior can be found in the \code{mvEWsamp} modelValues object.

  The auxiliary particle filter uses a lookahead function to select promising particles before propagation.  This function can eithre be the expected
  value of the latent state at the next time point (\code{lookahead = 'mean'}) or a simulation from the distribution of the latent state at the next time point (\code{lookahead = 'simulate'}), conditioned on the current particle.
}
\examples{
\dontrun{
model <- nimbleModel(code = ...)
my_AuxF <- buildAuxiliaryFilter(model, 'x[1:100]',
   control = list(saveAll = TRUE, lookahead = 'mean'))
Cmodel <- compileNimble(model)
Cmy_AuxF <- compileNimble(my_AuxF, project = model)
logLike <- Cmy_AuxF(m = 100000)
hist(as.matrix(Cmy_Auxf$mvEWSamples, 'x'))
}
}
\author{
Nicholas Michaud
}
\references{
Pitt, M.K., and Shephard, N. (1999). Filtering via simulation: Auxiliary particle filters. \emph{Journal of the American Statistical Association} 94(446): 590-599.
}
\seealso{
Other particle filtering methods: \code{\link{buildBootstrapFilter}};
  \code{\link{buildEnsembleKF}};
  \code{\link{buildLiuWestFilter}}
}

