% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/nimbleFunction_Rexecution.R
\name{nimNumeric}
\alias{integer}
\alias{logical}
\alias{nimInteger}
\alias{nimLogical}
\alias{nimNumeric}
\alias{numeric}
\title{Creates numeric, integer or logical vectors for use in nimbleFunctions}
\usage{
nimNumeric(length = 0, value = 0, init = TRUE, fillZeros = TRUE,
  recycle = TRUE)

nimInteger(length = 0, value = 0, init = TRUE, fillZeros = TRUE,
  recycle = TRUE)

nimLogical(length = 0, value = 0, init = TRUE, fillZeros = TRUE,
  recycle = TRUE)
}
\arguments{
\item{length}{the length of the vector (default = 0)}

\item{value}{value(s) for initializing the vector (default = 0).  This may be a vector, matrix or array but will be used as a vector.}

\item{init}{logical, whether to initialize elements of the vector (default = TRUE)}

\item{fillZeros}{logical, whether to initialize any elements not filled by (possibly recycled) \code{value} with 0 (or FALSE for \code{nimLogical}) (default = TRUE)}

\item{recycle}{logical, whether \code{value} should be recycled to fill the entire \code{length} of the new vector (default = TRUE)}
}
\description{
In a \code{nimbleFunction}, \code{numeric}, \code{integer} and \code{logical} are identical to \code{nimNumeric}, \code{nimInteger} and \code{nimLogical}, respectively.
}
\details{
These functions are similar to R's \code{\link{numeric}}, \code{\link{integer}}, \code{\link{logical}} functions, but they can be used in a nimbleFunction and then compiled using \code{compileNimble}.  Largely for compilation purposes, finer control is provided over initialization behavior.  If \code{init = FALSE}, no initialization will be done, and \code{value}, \code{fillZeros} and \code{recycle} will be ignored.  If \code{init=TRUE} and \code{recycle=TRUE}, then \code{fillZeros} will be ignored, and \code{value} will be repeated (according to R's recycling rule) as much as necessary to fill a vector of length \code{length}.  If \code{init=TRUE} and \code{recycle=FALSE}, then if \code{fillZeros=TRUE}, values of 0 (or FALSE for \code{nimLogical}) will be filled in after \code{value} up to length \code{length}.  Compiled code will be more efficient if unnecessary initialization is not done, but this may or may not be noticeable depending on the situation.

When used in a \code{nimbleFunction} (in \code{run} or other member function), \code{numeric}, \code{integer} and \code{logical} are immediately converted to \code{nimNumeric}, \code{nimInteger} and \code{nimLogical}, respectively.
}
\author{
Daniel Turek, Chris Paciorek, Perry de Valpine
}
\seealso{
\code{\link{nimMatrix}}, \code{\link{nimArray}}
}

