% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions_implementations.R
\name{Exponential}
\alias{Exponential}
\alias{dexp_nimble}
\alias{pexp_nimble}
\alias{qexp_nimble}
\alias{rexp_nimble}
\title{The Exponential Distribution}
\usage{
dexp_nimble(x, rate = 1/scale, scale = 1, log = FALSE)

rexp_nimble(n = 1, rate = 1/scale, scale = 1)

pexp_nimble(q, rate = 1/scale, scale = 1, lower.tail = TRUE,
  log.p = FALSE)

qexp_nimble(p, rate = 1/scale, scale = 1, lower.tail = TRUE,
  log.p = FALSE)
}
\arguments{
\item{x}{vector of values.}

\item{rate}{vector of rate values.}

\item{scale}{vector of scale values.}

\item{log}{logical; if TRUE, probability density is returned on the log scale.}

\item{n}{number of observations.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default) probabilities are \eqn{P[X \le x]}; otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities p are given by user as log(p).}

\item{p}{vector of probabilities.}
}
\value{
\code{dexp_nimble} gives the density, \code{pexp_nimble} gives the distribution
function, \code{qexp_nimble} gives the quantile function, and \code{rexp_nimble}
generates random deviates.
}
\description{
Density, distribution function, quantile function and random
  generation for the exponential distribution with rate
    (i.e., mean of \code{1/rate}) or scale parameterizations.
}
\details{
NIMBLE's exponential distribution functions use Rmath's functions
under the hood, but are parameterized to take both rate and scale and to
use 'rate' as the core parameterization in C, unlike Rmath, which uses 'scale'.
See Gelman et al., Appendix A or
the BUGS manual for mathematical details.
}
\examples{
x <- rexp_nimble(50, scale = 3)
dexp_nimble(x, scale = 3)
}
\author{
Christopher Paciorek
}
\references{
Gelman, A., Carlin, J.B., Stern, H.S., and Rubin, D.B. (2004) \emph{Bayesian Data Analysis}, 2nd ed. Chapman and Hall/CRC.
}
\seealso{
\link{Distributions} for other standard distributions
}

