% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{nimOptimMethod}
\alias{nimOptimMethod}
\title{Set or get an optimization function to be used by \code{nimOptim}}
\usage{
nimOptimMethod(name, value)
}
\arguments{
\item{name}{character string, giving the name of optimization method that
can be referred to by the \code{method} argument of \code{nimOptim}
(aka \code{optim} in a nimbleFunction).}

\item{value}{An optimization function with specifications described below and
in \code{\link{nimOptim}}. If \code{value} is \code{NULL}, then \code{name}
will be found in NIMBLE's set of registered optimizer names. If
\code{value} is missing, the registered optimizer for \code{name} will be
returned.}
}
\description{
Add, check, or remove an R optimization function to/from NIMBLE's set of
registered optimization functions that can be called from \code{nimOptim}.
}
\details{
When programming in nimbleFunctions, \code{optim}, which is converted
automatically to \code{\link{nimOptim}}, provides a generalization of R's
\code{optim} methods for optimization. If one of the supported original
\code{optim} methods is not chosen with the \code{method} argument to
\code{nimOptim}, an arbitrary method name can be given. If that name has been
registered as a \code{name} by a call to \code{nimOptimMethod}, then the
corresponding function (\code{value}) will be called for optimization.

The function \code{value} must perform minimization. If the call to
\code{nimOptim} includes a control list with either \code{fnscale} (which, if
negative, turns the problem into a maximization) or \code{parscale}, these
will be managed by \code{nimOptim} outside of the optimizer such that the
optimization should be minimization.

The function \code{value} must take named arguments \code{par} (initial
parameter vector), \code{fn} (objective function), \code{gr} (optional
gradient function), \code{he} (optional Hessian function), \code{lower}
(vector of lower bounds), \code{upper} (vector of upper bounds),
\code{control} (arbitrary control list), and \code{hessian} (logical
indicating whether a Hessian at the optimum is requested). It must return a
list with elements elements \code{par} (parameter values of the optimium,
i.e., "arg min"), \code{value} (function value at the minimum),
\code{convergence} (should be 0 if convergence occurred), \code{counts}
(optional vector of counts of calls to \code{fn}, \code{gr}, and \code{he}),
\code{evaluations} (optional total function evaluations), \code{message}
(optional character message), and \code{hessian} (optional Hessian matrix,
which may be NULL).

If the call to \code{nimOptim} has \code{hessian=TRUE}, that will be passed
as \code{hessian=TRUE} to the optimizer. However, if the optimizer returns a
\code{NULL} in the \code{hessian} element of the return list, then
\code{nimOptim} will calculate the Hessian by finite element differences.
Hence, an optimizer need not provide a Hessian capability.

The \code{control} list passed from \code{nimOptim} to the optimizer will
have only a limited set of the \code{optim} control list options. These will
include \code{abstol}, \code{reltol}, \code{maxit}, and \code{trace}. The
optimizer may use these as it wishes. Other control options for a particular
optimizer must be managed in some other way.

Note that it is possible to use \code{browser()} inside of \code{value}, or
to set \code{debug(value)}, to enter a browser when the optimizer
(\code{value}) is called and then inspect its arguments to make sense of the
situation.

This whole feature is particularly helpful when the nimbleFunction using
\code{nimOptim} has been compiled by \code{compileNimble}. Many optimizers
are available through R, so \code{nimOptim} arranges to call a named
(registered) optimizer in R, while providing \code{fn} and optionally
\code{gr} or \code{he} as functions that will call the compiled (by nimble)
versions of the corresponding functions provided in the call to
\code{nimOptim}.

R's optimizer \code{nlminb} is automatically registered under the name
\code{"nlminb"}.
}
