% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pamrI.R
\name{pamrTrain}
\alias{pamrTrain}
\title{Function providing a formula interface to pamr.train}
\usage{
pamrTrain(formula, data, ...)
}
\arguments{
\item{formula}{formula}

\item{data}{data frame}

\item{\dots}{further arguments to be passed to \code{pamr.train}}
}
\value{
Object that is perfectly identical to the object returned by
\code{pamr.train}
}
\description{
Function that provides a classical R modelling interface, using a
\code{formula} and \code{data} argument
}
\examples{

  set.seed(120)
  x <- matrix(rnorm(1000*20), ncol=20)
  y <- sample(c(1:4), size=20, replace=TRUE)
  alldf <- cbind.data.frame(t(x), y)
  pamrTrain(y ~ ., alldf)
}
\seealso{
\code{\link[pamr]{pamr.train}}
}
\author{
Tobias Verbeke
}
\keyword{models}
