% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloneNlmixr.R
\name{nlmixrClone}
\alias{nlmixrClone}
\title{Clone nlmixr environment}
\usage{
nlmixrClone(x)
}
\arguments{
\item{x}{nlmixr fit}
}
\value{
cloned nlmixr environment
}
\description{
Clone nlmixr environment
}
\examples{
\dontrun{

one.cmt <- function() {
  ini({
    ## You may label each parameter with a comment
    tka <- 0.45 # Log Ka
    tcl <- log(c(0, 2.7, 100)) # Log Cl
    ## This works with interactive models
    ## You may also label the preceding line with label("label text")
    tv <- 3.45; label("log V")
    ## the label("Label name") works with all models
    eta.ka ~ 0.6
    eta.cl ~ 0.3
    eta.v ~ 0.1
    add.sd <- 0.7
  })
  model({
    ka <- exp(tka + eta.ka)
    cl <- exp(tcl + eta.cl)
    v <- exp(tv + eta.v)
    linCmt() ~ add(add.sd)
  })
}

f <- nlmixr2(one.cmt, theo_sd, "saem")

nlmixrClone(f)

}
}
\author{
Matthew L. Fidler
}
