% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newuoa.R
\name{newuoaControl}
\alias{newuoaControl}
\title{Control for newuoa estimation method in nlmixr2}
\usage{
newuoaControl(
  npt = NULL,
  rhobeg = NULL,
  rhoend = NULL,
  iprint = 0L,
  maxfun = 100000L,
  returnNewuoa = FALSE,
  stickyRecalcN = 4,
  maxOdeRecalc = 5,
  odeRecalcFactor = 10^(0.5),
  useColor = crayon::has_color(),
  printNcol = floor((getOption("width") - 23)/12),
  print = 1L,
  normType = c("rescale2", "mean", "rescale", "std", "len", "constant"),
  scaleType = c("nlmixr2", "norm", "mult", "multAdd"),
  scaleCmax = 1e+05,
  scaleCmin = 1e-05,
  scaleC = NULL,
  scaleTo = 1,
  rxControl = NULL,
  optExpression = TRUE,
  sumProd = FALSE,
  literalFix = TRUE,
  addProp = c("combined2", "combined1"),
  calcTables = TRUE,
  compress = TRUE,
  covMethod = c("r", ""),
  adjObf = TRUE,
  ci = 0.95,
  sigdig = 4,
  sigdigTable = NULL,
  ...
)
}
\arguments{
\item{npt}{The number of points used to approximate the objective
function via a quadratic approximation for bobyqa. The value
of npt must be in the interval [n+2,(n+1)(n+2)/2] where n is
the number of parameters in par. Choices that exceed 2*n+1 are
not recommended. If not defined, it will be set to 2*n + 1. (bobyqa)}

\item{rhobeg}{Beginning change in parameters for bobyqa algorithm
(trust region).  By default this is 0.2 or 20% of the initial
parameters when the parameters are scaled to 1. rhobeg and
rhoend must be set to the initial and final values of a trust
region radius, so both must be positive with 0 < rhoend <
rhobeg. Typically rhobeg should be about one tenth of the
greatest expected change to a variable.  Note also that
smallest difference abs(upper-lower) should be greater than or
equal to rhobeg*2. If this is not the case then rhobeg will be
adjusted. (bobyqa)}

\item{rhoend}{The smallest value of the trust region radius that
is allowed. If not defined, then 10^(-sigdig-1) will be used. (bobyqa)}

\item{iprint}{The value of `iprint` should be set to an integer
value in `0, 1, 2, 3, ...`, which controls the amount of
printing.  Specifically, there is no output if `iprint=0` and
there is output only at the start and the return if `iprint=1`.
Otherwise, each new value of `rho` is printed, with the best
vector of variables so far and the corresponding value of the
objective function. Further, each new value of the objective
function with its variables are output if `iprint=3`.  If `iprint
> 3`, the objective function value and corresponding variables
are output every `iprint` evaluations.  Default value is `0`.}

\item{maxfun}{The maximum allowed number of function
evaluations. If this is exceeded, the method will terminate.}

\item{returnNewuoa}{return the newuoa output instead of the nlmixr2
fit}

\item{stickyRecalcN}{The number of bad ODE solves before reducing
the atol/rtol for the rest of the problem.}

\item{maxOdeRecalc}{Maximum number of times to reduce the ODE
tolerances and try to resolve the system if there was a bad
ODE solve.}

\item{odeRecalcFactor}{The ODE recalculation factor when ODE
solving goes bad, this is the factor the rtol/atol is reduced}

\item{useColor}{Boolean indicating if focei can use ASCII color codes}

\item{printNcol}{Number of columns to printout before wrapping
parameter estimates/gradient}

\item{print}{Integer representing when the outer step is
printed. When this is 0 or do not print the iterations.  1 is
print every function evaluation (default), 5 is print every 5
evaluations.}

\item{normType}{This is the type of parameter
    normalization/scaling used to get the scaled initial values
    for nlmixr2.  These are used with \code{scaleType} of.

    With the exception of \code{rescale2}, these come
    from
    \href{https://en.wikipedia.org/wiki/Feature_scaling}{Feature
    Scaling}. The \code{rescale2} The rescaling is the same type
    described in the
    \href{http://apmonitor.com/me575/uploads/Main/optimization_book.pdf}{OptdesX}
    software manual.

    In general, all all scaling formula can be described by:

    \deqn{v_{scaled}}{Vscaled} = (\deqn{v_{unscaled}-C_{1}}{Vunscaled-C1})/\deqn{C_{2}}{C2}


    Where


    The other data normalization approaches follow the following formula

    \deqn{v_{scaled}}{Vscaled} = (\deqn{v_{unscaled}-C_{1}}{Vunscaled-C1})/\deqn{C_{2}}{C2}

\itemize{

\item \code{rescale2} This scales all parameters from (-1 to 1).
    The relative differences between the parameters are preserved
    with this approach and the constants are:

    \deqn{C_{1}}{C1} = (max(all unscaled values)+min(all unscaled values))/2

    \deqn{C_{2}}{C2} = (max(all unscaled values) - min(all unscaled values))/2


\item \code{rescale} or min-max normalization. This rescales all
    parameters from (0 to 1).  As in the \code{rescale2} the
    relative differences are preserved.  In this approach:

    \deqn{C_{1}}{C1} = min(all unscaled values)

    \deqn{C_{2}}{C2} = max(all unscaled values) - min(all unscaled values)


\item \code{mean} or mean normalization.  This rescales to center
    the parameters around the mean but the parameters are from 0
    to 1.  In this approach:

    \deqn{C_{1}}{C1} = mean(all unscaled values)

    \deqn{C_{2}}{C2} = max(all unscaled values) - min(all unscaled values)

\item \code{std} or standardization.  This standardizes by the mean
     and standard deviation.  In this approach:

    \deqn{C_{1}}{C1} = mean(all unscaled values)

    \deqn{C_{2}}{C2} = sd(all unscaled values)

\item \code{len} or unit length scaling.  This scales the
   parameters to the unit length.  For this approach we use the Euclidean length, that
   is:

    \deqn{C_{1}}{C1} = 0

    \deqn{C_{2}}{C2} = \deqn{\sqrt(v_1^2 + v_2^2 + \cdots + v_n^2)}{sqrt(v_1^2 + v_2^2 + ... + v_n^2)}


\item \code{constant} which does not perform data normalization. That is

    \deqn{C_{1}}{C1} = 0

    \deqn{C_{2}}{C2} = 1

}}

\item{scaleType}{The scaling scheme for nlmixr2.  The supported types are:

\itemize{
\item \code{nlmixr2}  In this approach the scaling is performed by the following equation:

   \deqn{v_{scaled}}{Vscaled} = (\deqn{v_{current} - v_{init}}{Vcurrent - Vinit})*scaleC[i] + scaleTo

The \code{scaleTo} parameter is specified by the \code{normType},
and the scales are specified by \code{scaleC}.

\item \code{norm} This approach uses the simple scaling provided
    by the \code{normType} argument.

\item \code{mult} This approach does not use the data
normalization provided by \code{normType}, but rather uses
multiplicative scaling to a constant provided by the \code{scaleTo}
argument.

  In this case:

  \deqn{v_{scaled}}{Vscaled} = \deqn{v_{current}}{Vcurrent}/\deqn{v_{init}}{Vinit}*scaleTo

\item \code{multAdd} This approach changes the scaling based on
the parameter being specified.  If a parameter is defined in an
exponential block (ie exp(theta)), then it is scaled on a
linearly, that is:

  \deqn{v_{scaled}}{Vscaled} = (\deqn{v_{current}-v_{init}}{Vcurrent-Vinit}) + scaleTo

Otherwise the parameter is scaled multiplicatively.

   \deqn{v_{scaled}}{Vscaled} = \deqn{v_{current}}{Vcurrent}/\deqn{v_{init}}{Vinit}*scaleTo

}}

\item{scaleCmax}{Maximum value of the scaleC to prevent overflow.}

\item{scaleCmin}{Minimum value of the scaleC to prevent underflow.}

\item{scaleC}{The scaling constant used with
    \code{scaleType=nlmixr2}.  When not specified, it is based on
    the type of parameter that is estimated.  The idea is to keep
    the derivatives similar on a log scale to have similar
    gradient sizes.  Hence parameters like log(exp(theta)) would
    have a scaling factor of 1 and log(theta) would have a scaling
    factor of ini_value (to scale by 1/value; ie
    d/dt(log(ini_value)) = 1/ini_value or scaleC=ini_value)

   \itemize{

   \item For parameters in an exponential (ie exp(theta)) or
   parameters specifying powers, boxCox or yeoJohnson
   transformations , this is 1.

   \item For additive, proportional, lognormal error structures,
   these are given by 0.5*abs(initial_estimate)

   \item Factorials are scaled by abs(1/digamma(initial_estimate+1))

   \item parameters in a log scale (ie log(theta)) are transformed
   by log(abs(initial_estimate))*abs(initial_estimate)

   }

   These parameter scaling coefficients are chose to try to keep
   similar slopes among parameters.  That is they all follow the
   slopes approximately on a log-scale.

   While these are chosen in a logical manner, they may not always
   apply.  You can specify each parameters scaling factor by this
   parameter if you wish.}

\item{scaleTo}{Scale the initial parameter estimate to this value.
By default this is 1.  When zero or below, no scaling is performed.}

\item{rxControl}{`rxode2` ODE solving options during fitting, created with `rxControl()`}

\item{optExpression}{Optimize the rxode2 expression to speed up
calculation. By default this is turned on.}

\item{sumProd}{Is a boolean indicating if the model should change
multiplication to high precision multiplication and sums to
high precision sums using the PreciseSums package.  By default
this is \code{FALSE}.}

\item{literalFix}{boolean, substitute fixed population values as
literals and re-adjust ui and parameter estimates after
optimization; Default is `TRUE`.}

\item{addProp}{specifies the type of additive plus proportional
  errors, the one where standard deviations add (combined1) or the
  type where the variances add (combined2).

The combined1 error type can be described by the following equation:

  \deqn{y = f + (a + b\times f^c) \times \varepsilon}{y = f + (a + b*f^c)*err}

The combined2 error model can be described by the following equation:

 \deqn{y = f + \sqrt{a^2 + b^2\times f^{2\times c}} \times \varepsilon}{y = f + sqrt(a^2 + b^2*(f^c)^2)*err}

 Where:

 - y represents the observed value

 - f represents the predicted value

 - a  is the additive standard deviation

 - b is the proportional/power standard deviation

 - c is the power exponent (in the proportional case c=1)}

\item{calcTables}{This boolean is to determine if the foceiFit
will calculate tables. By default this is \code{TRUE}}

\item{compress}{Should the object have compressed items}

\item{covMethod}{Method for calculating covariance.  In this
    discussion, R is the Hessian matrix of the objective
    function. The S matrix is the sum of individual
    gradient cross-product (evaluated at the individual empirical
    Bayes estimates).

\itemize{

 \item "\code{r,s}" Uses the sandwich matrix to calculate the
 covariance, that is: \code{solve(R) \%*\% S \%*\% solve(R)}

 \item "\code{r}" Uses the Hessian matrix to calculate the
 covariance as \code{2 \%*\% solve(R)}

 \item "\code{s}" Uses the cross-product matrix to calculate the
 covariance as \code{4 \%*\% solve(S)}

 \item "" Does not calculate the covariance step.
}}

\item{adjObf}{is a boolean to indicate if the objective function
should be adjusted to be closer to NONMEM's default objective
function.  By default this is \code{TRUE}}

\item{ci}{Confidence level for some tables.  By default this is
0.95 or 95\% confidence.}

\item{sigdig}{Optimization significant digits. This controls:

\itemize{

 \item The tolerance of the inner and outer optimization is \code{10^-sigdig}

 \item The tolerance of the ODE solvers is
 \code{0.5*10^(-sigdig-2)}; For the sensitivity equations and
 steady-state solutions the default is \code{0.5*10^(-sigdig-1.5)}
 (sensitivity changes only applicable for liblsoda)

 \item The tolerance of the boundary check is \code{5 * 10 ^ (-sigdig + 1)}

}}

\item{sigdigTable}{Significant digits in the final output table.
If not specified, then it matches the significant digits in the
`sigdig` optimization algorithm.  If `sigdig` is NULL, use 3.}

\item{...}{Ignored parameters}
}
\value{
newuoa control structure
}
\description{
Control for newuoa estimation method in nlmixr2
}
\examples{

\donttest{
# A logit regression example with emax model

dsn <- data.frame(i=1:1000)
dsn$time <- exp(rnorm(1000))
dsn$DV=rbinom(1000,1,exp(-1+dsn$time)/(1+exp(-1+dsn$time)))

mod <- function() {
 ini({
   E0 <- 0.5
   Em <- 0.5
   E50 <- 2
   g <- fix(2)
 })
 model({
   v <- E0+Em*time^g/(E50^g+time^g)
   ll(bin) ~ DV * v - log(1 + exp(v))
 })
}

fit2 <- nlmixr(mod, dsn, est="newuoa")

print(fit2)

# you can also get the nlm output with

fit2$newuoa

# The nlm control has been modified slightly to include
# extra components and name the parameters
}
}
\author{
Matthew L. Fidler
}
