% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defaultCombine.R
\name{combinePaste2}
\alias{combinePaste2}
\title{Combine two strings using a naming convention}
\usage{
combinePaste2(
  a,
  b,
  combineType = c("default", "snake", "camel", "dot", "blank")
)
}
\arguments{
\item{a}{first string to combine}

\item{b}{second string to combine}

\item{combineType}{is the type of combination; can be:

- \code{"default"}: default combine (set with `defaultCombine()`)

- \code{"camel"}: camelCase combine

- \code{"snake"}: snake_case combine

- \code{"dot"}: dot combine (i.e. "a.b")

- \code{"blank"}: no separator (i.e. "ab")}
}
\value{
Combined strings separated with `defaultCombine()`
}
\description{
Combine two in a manner similar to `paste()` strings using the
default combine type
}
\examples{

combinePaste2("f", "depot")

combinePaste2("f", "depot", "snake")

combinePaste2("f", "depot", "dot")

combinePaste2("f", "depot", "blank")
}
\author{
Matthew L. Fidler
}
