% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rptnlmixr.R
\name{yaml_read_fit}
\alias{yaml_read_fit}
\title{Reads and Checks \code{report_fit.yaml} File}
\usage{
yaml_read_fit(
  obnd = NULL,
  rptyaml = NULL,
  placeholders = NULL,
  parameters = NULL,
  fit = NULL
)
}
\arguments{
\item{obnd}{onbrand report object to have report elements appended to.}

\item{rptyaml}{yaml file containing the report elements and structure.}

\item{placeholders}{list of placeholders to overwrite defaults in the yaml file.}

\item{parameters}{list with element names for each parameter to overwrite at runtime.
with a named list for example RUN may be "RUNN" in the yaml file. To
overwrite this just provide \code{list(RUN="RUN_1")}
(default: \code{NULL})}

\item{fit}{nlmixr2 fit object to be reported.}
}
\value{
List containing the following information about the report
\itemize{
\item \code{"isgood"} - Boolean variable indicating success or failure
\item \code{"msgs"} - Vector of messages
\item \code{"rpttype"} - Type of onbrand report ("Word" or "PowerPoint")
\item \code{"rptfigfmt"} - Default figure formatting (orientation and dimensions)
\item \code{"rpttabfmt"} - Default table formatting (orientation and dimensions)
\item \code{"rptdetails"} - Contents of the yaml file
\item \code{"rptcont"} - Contents of the report to generate
}
}
\description{
Reads in the report yaml file and looks it to make sure it has all
the necessary fields for the given report.
}
\examples{
# We need an onbrand object to use below
library(onbrand)  
obnd = read_template(
 template = system.file(package="nlmixr2rpt", "templates","nlmixr_obnd_template.docx"),
 mapping  = system.file(package="nlmixr2rpt", "templates","nlmixr_obnd_template.yaml"))

# We also need an nlmixr fit object
fit = fetch_fit_example()

# This reads in the report details
yaml_read_res = yaml_read_fit(
 obnd    = obnd,
 rptyaml = system.file(package="nlmixr2rpt", "examples", "report_fit_test.yaml"),
 fit     = fit)
}
