# nlraa: R pacakge for Nonlinear Regression for Agricultural
# Applications

[![CRAN](http://www.r-pkg.org/badges/version/nlraa)](https://CRAN.R-project.org/package=nlraa)
[![CRAN
downloads total](https://cranlogs.r-pkg.org/badges/grand-total/nlraa)](https://github.com/metacran/cranlogs.app)
[![CRAN downloads](https://cranlogs.r-pkg.org/badges/nlraa)](https://cran.r-project.org/package=nlraa)

This package supports the following publications:

1. Archontoulis, S. V., and F. E. Miguez. 2015. Nonlinear Regression
   Models and Applications in Agricultural
   Research. Agron. J. 107:786-798. \
   https://doi.org/10.2134/agronj2012.0506

2. Miguez, F., S. Archontoulis, H. Dokoohaki 2018. Chapter 15:
   Nonlinear Regression Models and Applications. In: B. Glaz,
   K. M. Yeater, editors, Applied Statistics in Agricultural,
   Biological, and Environmental Sciences, ASA, CSSA, and SSSA,
   Madison, WI. p. 401-448. \
   https://doi.org/10.2134/appliedstatistics.2016.0003

3. Oddi et. al. (2019). A nonlinear mixed-effects modelling approach
   for ecological data: Using temporal dynamics of vegetation moisture
   as an example. Ecology and Evolution. \
   https://doi.org/10.1002/ece3.5543

Other publications where we have used nonlinear mixed models:

1. Fernando E. Miguez, María Bonita Villamil, Stephen P. Long,
    Germán A. Bollero, Meta-analysis of the effects of management
    factors on Miscanthus × giganteus growth and biomass production,
    Agricultural and Forest Meteorology, Volume 148, Issues 8–9, 2008,
    Pages 1280-1292, ISSN 0168-1923, \
    https://doi.org/10.1016/j.agrformet.2008.03.010. \
	Supporting information: \
	http://miguezlab.agron.iastate.edu/OldWebsite/Research/Miscanthus/MetaMiscan.tar.gz

2. Eichenberger, S., F. Miguez, J. Edwards, and A. Knapp. 2015. Changes
    in Kernel Filling with Selection for Grain Yield in a Maize
    Population. Crop Sci. 55:521-526. \
	https://doi.org/10.2135/cropsci2014.07.0462

3. Stein, M., F. Miguez, and J. Edwards. 2016. Effects of Plant Density
    on Plant Growth before and after Recurrent Selection in
    Maize. Crop Sci. 56:2882-2894. \
	https://doi.org/10.2135/cropsci2015.09.0599

Talks:

2008 ACS meeting.

Slides: \
http://miguezlab.agron.iastate.edu/OldWebsite/Research/Talks/ASA_Miguez.pdf

Data and code: \
http://miguezlab.agron.iastate.edu/OldWebsite/Research/Talks/Barley.zip

Ideas for future versions:

* Include more data and analysis code from the above examples
* Include more SS functions

To install

> library(remotes) \
> remotes::install_github("femiguez/nlraa") \
> library(nlraa)
