% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSscard3.R
\name{SScard3}
\alias{SScard3}
\alias{card3}
\title{self start for cardinal temperature response}
\usage{
card3(x, tb, to, tm)

SScard3(x, tb, to, tm)
}
\arguments{
\item{x}{input vector (x) which is normally \sQuote{temperature}.}

\item{tb}{base temperature}

\item{to}{optimum temperature}

\item{tm}{maximum temperature}
}
\value{
card3: vector of the same length as x using a card3 function
}
\description{
Self starter for cardinal temperature response function
}
\details{
This function is described in Archontoulis and Miguez (2015) - (doi:10.2134/agronj2012.0506)
}
\examples{
\donttest{
## A temperature response function
require(ggplot2)
set.seed(1234)
x <- 1:50
y <- card3(x, 13, 25, 36) + rnorm(length(x), sd = 0.05)
dat1 <- data.frame(x = x, y = y)
fit1 <- nls(y ~ SScard3(x, tb, to, tm), data = dat1)

ggplot(data = dat1, aes(x, y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit1)))
}
}
\author{
Caio dos Santos and Fernando Miguez
}
