% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runnetmeta.R
\name{runnetmeta}
\alias{runnetmeta}
\title{Run \code{netmeta}}
\usage{
runnetmeta(recid, model = "random", measure = "notset")
}
\arguments{
\item{recid}{ID of network in database}

\item{model}{"fixed" or "random"; specifies if fixed or random effects 
network meta-analysis should be conducted.}

\item{measure}{\itemize{
\item "notset" (default) is the type of effect 
   measure in the original publication
\item "OR" odds ratio for binary data
\item "RR" risk ratio for binary data
\item "RD" risk difference for binary data
\item "MD" mean difference for continuous data
\item "SMD" standardized mean difference for continuous data
\item "HR" hazard ratio for survival data
\item "IRR" incidence rate ratio for rate data
}
If the measure entered is not compatible with network's type you get an error}
}
\value{
An object of class netmeta; for the descirption 
  of the components included in the object, see the help file of
  \code{\link[netmeta]{netmeta}}.
}
\description{
R package \code{\link[netmeta]{netmeta}} provides frequenstist methods 
for network meta-analysis based on Rücker (2012) and Rücker (2014). 
This function is used to run netmeta on a specified network 
included in the database of network meta-analyses,
which can be downloaded using function \code{\link{getNMADB}}.
}
\examples{
\dontrun{
  Conduct random effects network meta-analysis 
  in a random network with continuous outcome
}
cid <- 501427
netc <- readByID(cid)
\dontrun{get type and effect}
netc$type
netc$effect
\dontrun{In order to run netmeta but get "SMD" summary effects instead}
runnetmeta(recid=cid, measure="SMD")

\donttest{

\dontrun{If we the following example choosing OR we get an error
runnetmeta(recid=cid, measure="OR")}

\dontrun{As before for a network with binary outcome}
bid <- 481216
netb <- readByID(bid)
\dontrun{get type and effect}
netb$type
netb$effect
runnetmeta(recid=bid, measure="OR")
 
\dontrun{Survival outcome}
sid <- 479888
nets <- readByID(sid)
\dontrun{get type and effect}
nets$type
nets$effect
runnetmeta(recid=sid)
 
\dontrun{Rate outcome}
rid <- 479999
netr <- readByID(rid)
\dontrun{get type and effect}
netr$type
netr$effect
runnetmeta(recid=rid)
}
 
}
\references{
Rücker G (2012) <doi:10.1002/jrsm.1058>.

  Rücker G, Schwarzer G (2014) <doi:10.1002/sim.6236>.
}
\seealso{
\code{\link[netmeta]{netmeta}}
,\code{\link{getNMADB}}
,\code{\link{readByID}}
}
