% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresh_2d.R
\name{thresh_2d}
\alias{thresh_2d}
\title{Producing two-dimensional invariant regions}
\usage{
thresh_2d(thresh, idx, idy, xlab = paste("Adjustment to data point", idx),
  ylab = paste("Adjustment to data point", idy), xlim = NULL, ylim = NULL,
  breaks = waiver(), xbreaks = breaks, ybreaks = breaks,
  fill = rgb(0.72, 0.8, 0.93, 0.7), lwd = 1, fontsize = 12)
}
\arguments{
\item{thresh}{A \code{thresh} object, as produced by
\code{\link{nma_thresh}}.}

\item{idx}{Integer specifying the index (with respect to
\code{thresh$thresholds}) of the first data point to consider adjusting.
Will be shown on the x axis.}

\item{idy}{Integer specifying the index (with respect to
\code{thresh$thresholds}) of the second data point to consider adjusting.
Will be shown on the y axis.}

\item{xlab}{Character string giving the label for the x axis.}

\item{ylab}{Character string giving the label for the y axis.}

\item{xlim}{Numeric vector of length 2, giving the x axis limits.}

\item{ylim}{Numeric vector of length 2, giving the y axis limits.}

\item{breaks}{Numeric vector giving position of tick marks on the x and y
axes. Calculated automatically by default.}

\item{xbreaks}{Numeric vector giving position of tick marks on the x axis.
Equal to \code{breaks} by default, if set this overrides any value given to
\code{breaks}.}

\item{ybreaks}{Numeric vector giving position of tick marks on the y axis.
Equal to \code{breaks} by default, if set this overrides any value given to
\code{breaks}.}

\item{fill}{Fill colour for invariant region. Defaults to a nice shade of
blue \code{rgb(.72, .80, .93, .7)}.}

\item{lwd}{Line width for threshold lines. Default 1.}

\item{fontsize}{Font size for labels. Default 12.}
}
\value{
A \code{ggplot} object containing the 2D threshold plot, which is
  returned invisibly and plotted (unless assigned).
}
\description{
This function produces two-dimensional threshold lines and invariant regions,
as shown by Phillippo \emph{et al.} (2017).
}
\examples{
# Please see the vignette "Examples" for worked examples including use of
# this function, including more information on the brief code below.

vignette("Examples", package = "nmathresh")

### Contrast level thresholds for Thrombolytic treatments NMA
K <- 6   # Number of treatments

# Contrast design matrix is
X <- matrix(ncol = K-1, byrow = TRUE,
            c(1, 0, 0, 0, 0,
              0, 1, 0, 0, 0,
              0, 0, 1, 0, 0,
              0, 0, 0, 1, 0,
              0, -1, 1, 0, 0,
              0, -1, 0, 1, 0,
              0, -1, 0, 0, 1))

# Reconstruct hypothetical likelihood covariance matrix using NNLS
lik.cov <- recon_vcov(Thrombo.post.cov, prior.prec = .0001, X = X)

# Thresholds are then
thresh <- nma_thresh(mean.dk = Thrombo.post.summary$statistics[1:(K-1), "Mean"],
                     lhood = lik.cov,
                     post = Thrombo.post.cov,
                     nmatype = "fixed",
                     X = X,
                     opt.max = FALSE)

# Produce an invariant region for simultaneous adjustments to both arms of Study 1
thresh_2d(thresh, 1, 2,
          xlab = "Adjustment in Study 1 LOR: 3 vs. 1",
          ylab = "Adjustment in Study 1 LOR: 4 vs. 1",
          xlim = c(-1.5, 0.5), ylim = c(-2, 14),
          ybreaks = seq(-2, 14, 2))

}
