% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexing.R
\name{d_ab2i}
\alias{d_ab2i}
\alias{d_i2ab}
\alias{d_i2ab}
\title{Convert contrast indexing}
\usage{
d_ab2i(a, b, K)

d_i2ab(i, K)
}
\arguments{
\item{a}{Vector of treatment codes \eqn{a}.}

\item{b}{Vector of treatment codes \eqn{b}.}

\item{K}{Total number of treatments.}

\item{i}{Vector of indices \code{i}.}
}
\value{
\code{d_ab2i} returns a vector of indices \code{i}. \code{d_i2ab}
  returns a data frame of indices \code{a} and \code{b}.
}
\description{
Functions for converting between \eqn{d_{ab}} indexing of contrasts (useful
notationally) and \code{d[i]} indexing used by R.
}
\section{Functions}{
\itemize{
\item \code{d_ab2i}: Convert \code{d[i]} type indices to \eqn{d_{ab}} type indices.

\item \code{d_i2ab}: Convert \eqn{d_{ab}} type indices to \code{d[i]} type indices.
}}

\note{
By convention, \eqn{1 \le a < b \le K}. If this is not the case, an
  error will be thrown. For a given number of treatments \eqn{K}, the total
  number of possible contrasts \eqn{d_{ab}} is \eqn{K(K-1)/2}, and hence
  \eqn{i \le K}. Again, if this is not the case, an error will be thrown.
}
\examples{
d_ab2i(c(1,1,1, 2,2, 3), c(2,3,4, 3,4, 4), K=4)
d_i2ab(1:6, K=4)

}
