% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmfem_mult.R
\name{nmfem_mult}
\alias{nmfem_mult}
\title{NMF-EM algorithm for mixture of multinomials}
\usage{
nmfem_mult(X, H, K, path = NULL, eps_init = 0.001, eps_M = 1e-08,
  eps_llh = 1e-05)
}
\arguments{
\item{X}{a matrix containing multinomials observations of dimension \code{N} (number of observation) \code{x M} (number of variables).}

\item{H}{number of words.}

\item{K}{number of clusters.}

\item{path}{path to the directory to save the initialization or to load it. NULL by default, won't save or load it.}

\item{eps_init}{convergence criterion on the initialization. Default value is 1e-3.}

\item{eps_M}{convergence criterion on the Maximization step. Default value is 1e-8.}

\item{eps_llh}{convergence criterion on the log-likelihood. Default value is 1e-5.}
}
\value{
A list with the elements:
\item{Theta}{matrix of dimension \code{M x H}. Contains a dictionnary of redundant components.}
\item{Lambda}{matrix of dimension \code{H x K}. Contains the expression of the \code{K} clusters in the dictionnary.}
\item{llh}{log-likelihood of the model.}
\item{p}{vector containing the proportions of each cluster.}
\item{t}{matrix containing for each observation the probability to belong to each cluster.}
}
\description{
Proceed to an NMF-EM algorithm on mixture of multinomials dataset. In comparison to the classical EM algorithm, the number of parameters to estimate is lower. For more explanation, see pre-print of Carel and Alquier (2017) <arXiv:1709.03346>.
}
\examples{

# Example on a data sample
x <- dplyr::sample_n(travelers[,-1],900)
out <- nmfem_mult(x, H = 4, K = 7)
# Display first cluster profile
display_profile(t((out$Theta \%*\% out$Lambda)[ ,1]))
# Display first word profile
display_profile(t(out$Theta[ ,1]), color = "Greens")

# Example on the complete data - it needs a few minutes to run
\dontrun{
nmfem_travelers <- nmfem_mult(travelers[ ,-1], H = 5, K = 10)
Theta <- nmfem_travelers$Theta
Lambda <- nmfem_travelers$Lambda

# Display first cluster profile
display_profile(t((Theta \%*\% Lambda)[ ,1]))

# Display first word profile
display_profile(t(Theta[ ,1]), color = "Greens")}

}
