% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{EV.Tcomb}
\alias{EV.Tcomb}
\title{Expected Value for Cuzick & Edwards \eqn{T_{comb}} Test Statistic}
\usage{
EV.Tcomb(n1, n, klist, sig)
}
\arguments{
\item{n1}{Number of cases}

\item{n}{A positive integer representing the number of points in the data set}

\item{klist}{\code{list} of integers specifying the indices of the \eqn{T_k} values used in obtaining the \eqn{T_{comb}}.}

\item{sig}{The covariance matrix of the vector of \eqn{T_k} values used in \code{Tcomb}}
}
\value{
Returns the expected value of the \eqn{T_{comb}} test statistic
}
\description{
This function computes the expected value of Cuzick & Edwards \eqn{T_{comb}} test statistic in disease clustering,
where \eqn{T_{comb}} is a linear combination of some \eqn{T_k} tests. 

The argument, \eqn{n_1}, is the number of cases (denoted as \code{n1} as an argument).
The number of cases is denoted as \eqn{n_1} to match the case-control class labeling,
which is just the reverse of the labeling in \insertCite{cuzick:1990;textual}{nnspat}.

The argument \code{klist} is the \code{vector} of integers specifying the indices of the \eqn{T_k} values used
in obtaining the \eqn{T_{comb}}.

The argument \code{sig} is the covariance matrix of the vector of \eqn{T_k} values used in \code{Tcomb}, and can be computed
via the the \code{\link{covTcomb}} function.
  
See page 87 of (\insertCite{cuzick:1990;textual}{nnspat}) for more details.
}
\examples{
n<-20  #or try sample(1:20,1) #try also n<-50, 100
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)  #or try cls<-rep(0:1,c(10,10))
n1<-sum(cls==1)

kl<-sample(1:5,3) #try also sample(1:5,2)
kl
sig<-covTcomb(Y,n1,kl)
EV.Tcomb(n1,n,kl,sig)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Tcomb}}, and \code{\link{ZTcomb}}
}
\author{
Elvan Ceyhan
}
