% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{Znnsym}
\alias{Znnsym}
\title{NN Symmetry Test with Normal Approximation}
\usage{
Znnsym(
  dat,
  lab,
  type = "dixon",
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point.}

\item{lab}{The \code{vector} of class labels (numerical or categorical)}

\item{type}{The type of the NN symmetry test with default=\code{"dixon"}.
Takes on values \code{"dixon"} and \code{"pielou"} for Dixon's and Pielou's (first type) NN symmetry test}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, 
for the difference of the off-diagonal entries, \eqn{N_{12}-N_{21}}}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function}
}
\value{
A \code{list} with the elements
\item{statistic}{The \code{matrix} of \eqn{Z} test statistics for the NN symmetry test (in the upper-triangular form)}
\item{stat.names}{Name of the test statistics}
\item{p.value}{The \code{matrix} of \eqn{p}-values for the hypothesis test for the corresponding alternative
(in the upper-triangular form)}
\item{LCL,UCL}{Matrix of Lower and Upper Confidence Levels (in the upper-triangular form) for the \eqn{N_{ij}-N_{ji}}
values for \eqn{i \ne j} at the given confidence level \code{conf.level} and depends on the type of \code{alternative}.} 
\item{conf.int}{The confidence interval for the estimates, it is \code{NULL} here, since we provide the \code{UCL} and \code{LCL}
in \code{matrix} form.}
\item{cnf.lvl}{Level of the upper and lower confidence limits (i.e., conf.level) of the differences of the
off-diagonal entries.}
\item{estimate}{Estimates of the parameters, i.e., matrix of the difference of the off-diagonal entries
(in the upper-triangular form) of the \eqn{k \times k} NNCT, \eqn{N_{ij}-N_{ji}} for \eqn{i \ne j}.}
\item{est.name,est.name2}{Names of the estimates, former is a shorter description of the estimates
than the latter.}
\item{null.value}{Hypothesized null value for the expected difference between the off-diagonal entries, 
\eqn{E(N_{ij})-E(N_{ji})} for \eqn{i \ne j} in the \eqn{k \times k} NNCT, which is 0 for this function.}
\item{null.name}{Name of the null values}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set, \code{dat}, or name of the contingency table, \code{ct}}
}
\description{
An object of class \code{"cellhtest"} performing hypothesis test of equality of the expected values of the
off-diagonal cell counts (i.e., entries) for each pair \eqn{i,j} of classes under RL or CSR in the NNCT
for \eqn{k \ge 2} classes.
That is, the test performs Dixon's or Pielou's (first type of) NN symmetry test which is appropriate 
(i.e. have the appropriate asymptotic sampling distribution)
for completely mapped data or for sparsely sample data, respectively.
(See \insertCite{pielou:1961,dixon:1994,ceyhan:SWJ-spat-sym2014;textual}{nnspat} for more detail).

The \code{type="dixon"} refers to Dixon's NN symmetry test and 
\code{type="pielou"} refers to Pielou's first type of NN symmetry test.
The symmetry test is based on the normal approximation of the difference of the off-diagonal entries
in the NNCT and are due to \insertCite{pielou:1961,dixon:1994;textual}{nnspat}.

The function yields a contingency table of the test statistics, \eqn{p}-values for the corresponding 
alternative, expected values (i.e. null value(s)), lower and upper confidence levels and sample estimate
for the \eqn{N_{ij}-N_{ji}} values for \eqn{i \ne j} (all in the upper-triangular form except for the null value, which is 0
for all pairs) and also names of the test statistics, estimates, null values and the method and the data
set used.

The null hypothesis is that all \eqn{E(N_{ij})=E(N_{ji})} for \eqn{i \ne j} in the \eqn{k \times k} NNCT (i.e., symmetry in the 
mixed NN structure) for \eqn{k \ge 2}.
In the output, if if \code{type="pielou"}, 
the test statistic, \eqn{p}-value and the lower and upper confidence limits are valid only 
for (properly) sparsely sampled data.

See also
(\insertCite{pielou:1961,dixon:1994,ceyhan:SWJ-spat-sym2014;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))

Znnsym(Y,cls)
Znnsym(Y,cls,method="max")
Znnsym(Y,cls,type="pielou")
Znnsym(Y,cls,type="pielou",method="max")

Znnsym(Y,cls,alt="g")
Znnsym(Y,cls,type="pielou",alt="g")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
Znnsym(Y,fcls)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))

Znnsym(Y,cls)
Znnsym(Y,cls,type="pielou")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Znnsym.ss.ct}}, \code{\link{Znnsym.ss}}, \code{\link{Znnsym.dx.ct}},
\code{\link{Znnsym.dx}} and \code{\link{Znnsym2cl}}
}
\author{
Elvan Ceyhan
}
