% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{funsXsq.nnref}
\alias{funsXsq.nnref}
\alias{Xsq.nnref.ct}
\alias{Xsq.nnref}
\title{Reflexivity Test with Chi-square Approximation}
\usage{
Xsq.nnref.ct(rfct, nvec, Qv, Tv)

Xsq.nnref(dat, lab, ...)
}
\arguments{
\item{rfct}{An RCT, used in \code{Xsq.nnref.ct} only}

\item{nvec}{The \code{vector} of class sizes, used in \code{Xsq.nnref.ct} only}

\item{Qv}{The number of shared NNs, used in \code{Xsq.nnref.ct} only}

\item{Tv}{\eqn{T} value, which is the number of triplets \eqn{(z_i, z_j, z_k)} with 
\eqn{NN(z_i) = NN(z_j) = z_k} and \eqn{NN(z_k) = z_j} where \eqn{NN(\cdot)} is the nearest neighbor function, used in \code{Xsq.nnref.ct} only.}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{Xsq.nnref} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{Xsq.nnref} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function, used in \code{Xsq.nnref} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The chi-squared test statistic for overall NN reflexivity test}
\item{p.value}{The \eqn{p}-value for the hypothesis test}
\item{df}{Degrees of freedom for the chi-squared test, which is 2 for this function.}
\item{estimate}{Estimates of the parameters, i.e., the observed diagonal entries \eqn{(1,1)} and \eqn{(2,2)}
in the RCT, \code{rfct}.}
\item{est.name,est.name2}{Names of the estimates, they are identical for this function.}
\item{null.value}{Hypothesized null values for the diagonal entries \eqn{(1,1)} and \eqn{(2,2)} in the RCT, 
which are \eqn{E(N_{11})=R P_{aa}} and \eqn{E(N_{22})=R P_{ab}}, respectively).}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{rfct}, returned by \code{Xsq.nnref.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{Xsq.nnref} only}
}
\description{
Two functions: \code{Xsq.nnref.ct} and \code{Xsq.nnref}.

Both functions are objects of class \code{"Chisqtest"} but with different arguments (see the parameter list below).
Each one performs hypothesis tests of equality of the expected values of the
diagonal cell counts (i.e., entries) under RL or CSR in the RCT for \eqn{k \ge 2} classes.
That is, each test performs an overall NN reflexivity test (for the vector of entries \eqn{(1,1)} and \eqn{(2,2)},
respectively, in the RCT) which is
appropriate (i.e. have the appropriate asymptotic sampling distribution) for completely mapped data.
(See \insertCite{ceyhan:NNreflexivity2017;textual}{nnspat} for more detail).

Each reflexivity test is based on the chi-squared approximation of the corresponding quadratic form
for the vector of diagonal entries 
in the RCT and are due to \insertCite{ceyhan:NNreflexivity2017;textual}{nnspat}.

Each function yields the test statistic, \eqn{p}-value and \code{df} which is 2, description of the 
alternative with the corresponding null values (i.e. expected values) of the diagonal entries
and also the sample estimates (i.e. observed values) of the diagonal entries of RCT (as a vector).
The functions also provide names of the test statistics, the method and the data set used.

The null hypothesis is that \eqn{E(N_{11},N_{22})=(R P_{aa},R P_{ab})} in the RCT, where \eqn{R} is the number of reflexive
NNs and \eqn{P_{aa}} is the probability of any two points selected are being from the same class
and \eqn{P_{ab}} is the probability of any two points selected are being from two different classes.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))

ipd<-ipd.mat(Y)
W<-Wmat(ipd)
Qv<-Qvec(W)$q
R<-Rval(W)
Tv<-Tval(W,R)

nvec<-as.numeric(table(cls))
rfct<-rct(ipd,cls)

Xsq.nnref(Y,cls)
Xsq.nnref.ct(rfct,nvec,Qv,Tv)

Xsq.nnref(Y,cls,method="max")

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))

ipd<-ipd.mat(Y)
W<-Wmat(ipd)
Qv<-Qvec(W)$q
R<-Rval(W)
Tv<-Tval(W,R)

nvec<-as.numeric(table(cls))
rfct<-rct(ipd,cls)

Xsq.nnref(Y,cls)
Xsq.nnref.ct(rfct,nvec,Qv,Tv)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Znnref.ct}}, \code{\link{Znnref}}, \code{\link{Zself.ref.ct}},
\code{\link{Zself.ref}}, \code{\link{Zmixed.nonref.ct}} and \code{\link{Zmixed.nonref}}
}
\author{
Elvan Ceyhan
}
