% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{funsZnnself.sum}
\alias{funsZnnself.sum}
\alias{Znnself.sum.ct}
\alias{Znnself.sum}
\title{Cumulative Species Correspondence Test with Normal Approximation}
\usage{
Znnself.sum.ct(
  ct,
  covSC,
  nnct = FALSE,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)

Znnself.sum(
  dat,
  lab,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{ct}{The NNCT or SCCT, used in \code{Znnself.sum.ct} only}

\item{covSC}{The covariance matrix for the self entries (i.e. first column) in the SCCT
or the diagonal entries in the NNCT, used in \code{Znnself.sum.ct} only. Usually output of the functions 
\code{\link{covNii.ct}} or \code{\link{covNii}}.}

\item{nnct}{A logical parameter (default=\code{FALSE}). If \code{TRUE}, \code{x} is taken to be the \eqn{k \times k} NNCT, 
and if \code{FALSE}, \code{x} is taken to be the IPD matrix, used in \code{Znnself.sum.ct} only}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, 
for the self entries in the SCCT or diagonal entries in the NNCT}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{Znnself.sum} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{Znnself.sum} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
used in \code{Znnself.sum} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The \eqn{Z} test statistic for the overall species correspondence test}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding alternative}
\item{conf.int}{Confidence interval for the sum of the self entries (i.e. first column) in a
species correspondence contingency table (SCCT) or the sum of the diagonal entries \eqn{N_{ii}} in an NNCT
at the given confidence level \code{conf.level} and depends on the type of \code{alternative}.} 
\item{estimate}{Estimate of the parameter, i.e., the observed sum of the self entries (i.e. first column)
in a species correspondence contingency table (SCCT) or the sum of the diagonal entries \eqn{N_{ii}} in an NNCT.}
\item{null.value}{Hypothesized null value for the sum of the self entries (i.e. first column) in a
species correspondence contingency table (SCCT) or the sum of the diagonal entries \eqn{N_{ii}} in an NNCT
which is \eqn{E[S] = \sum_{i=1}^k n_i(n_i - 1)/(n - 1)} where \eqn{S} is the sum of the self column
in the SCCT, \eqn{n_i} is the size of class \eqn{i} and \eqn{n} is the data size.}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{Znnself.sum.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{Znnself.sum} only}
}
\description{
Two functions: \code{Znnself.sum.ct} and \code{Znnself.sum}.

Both functions are objects of class \code{"htest"} but with different arguments (see the parameter list below).
Each one performs hypothesis tests of equality of the expected value of the sum of the self entries (i.e.
first column) in a species correspondence contingency table (SCCT) or the expected values of the sum of the 
diagonal entries \eqn{N_{ii}} in an NNCT to the one under RL or CSR.
That is, each performs a cumulative species correspondence test which is appropriate 
(i.e. have the appropriate asymptotic sampling distribution)
for completely mapped data.
(See \insertCite{ceyhan:NNCorrespond2018;textual}{nnspat} for more detail).

Each test is based on the normal approximation of the sum of the self entries (i.e. first column) in a
species correspondence contingency table (SCCT) or the sum of the diagonal entries \eqn{N_{ii}} in an NNCT and
are due to \insertCite{ceyhan:NNCorrespond2018}{nnspat}.

Each function yields the test statistic, \eqn{p}-value for the
corresponding alternative, the confidence interval, sample estimate (i.e. observed value) and null (i.e., expected) value for the
sum of the self entries (i.e. first column) in a
species correspondence contingency table (SCCT) or the sum of the diagonal entries \eqn{N_{ii}} in an NNCT, 
and method and name of the data set used.

The null hypothesis is that all 
\eqn{E[S] = \sum_{i=1}^k n_i(n_i - 1)/(n - 1)} where \eqn{S} is the sum of the self column
in the SCCT, \eqn{n_i} is the size of class \eqn{i} and \eqn{n} is the data size. 

The \code{Znnself.sum} functions (i.e. \code{Znnself.sum.ct} and \code{Znnself.sum}) are different from the Znnself
functions (i.e. \code{Znnself.ct} and \code{Znnself}), and from the \code{Znnref} functions 
(i.e. \code{\link{Znnref.ct}} and \code{\link{Znnref}}) and also from \code{Zself.ref} functions (i.e. \code{\link{Zself.ref.ct}} and \code{\link{Zself.ref}}).
\code{Znnself.sum} functions are testing the cumulative species correspondence using the sum of the self column (i.e.,
the first column) in the SCCT, while \code{Znnself} functions are testing the self reflexivity at a class-specific level (i.e. for each class) using the
first column in the SCCT, while \code{Zself.ref} functions are for testing the self reflexivity for the entire data set
using entry \eqn{(1,1)} in RCT, and \code{Znnref} functions are for testing the self reflexivity and mixed non-reflexivity
using the diagonal entries in the RCT.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-scct(ipd,cls)
ct

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)

vsq<-varNii.ct(ct,Qv,Rv)
cv<-covNii.ct(ct,vsq,Qv,Rv)

Znnself.sum(Y,cls)

Znnself.sum.ct(ct,cv)
Znnself.sum.ct(ct,cv,alt="g")

Znnself.sum(Y,cls,method="max")

ct<-nnct(ipd,cls)
Znnself.sum.ct(ct,cv,nnct = TRUE)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ipd<-ipd.mat(Y)
ct<-scct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)

vsq<-varNii.ct(ct,Qv,Rv)
cv<-covNii.ct(ct,vsq,Qv,Rv)

Znnself.sum(Y,cls)

Znnself.sum.ct(ct,cv)
Znnself.sum.ct(ct,cv,alt="g")

ct<-nnct(ipd,cls)
Znnself.sum.ct(ct,cv,nnct = TRUE)

Znnself.sum(Y,cls,alt="g")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Znnself.ct}}, \code{\link{Znnself}}, \code{\link{Znnref.ct}}, \code{\link{Znnref}},
\code{\link{Zself.ref.ct}} and \code{\link{Zself.ref}}
}
\author{
Elvan Ceyhan
}
