% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{ceTrun}
\alias{ceTrun}
\title{Cuzick and Edwards \eqn{T_{run}} Test statistic}
\usage{
ceTrun(dat, cc.lab, case.lab = NULL, ...)
}
\arguments{
\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point.}

\item{cc.lab}{Case-control labels, 1 for case, 0 for control}

\item{case.lab}{The label used for cases in the \code{cc.lab} (if \code{cc.lab} is not provided then the labels are converted
such that cases are 1 and controls are 0), default is \code{NULL}.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
A \code{list} with two elements
\item{Trun}{Cuzick and Edwards \eqn{T_{run}} test statistic for disease clustering}
\item{run.vec}{The \code{vector} of number of consecutive cases till the first control for each point in the data set}
}
\description{
This function computes Cuzick and Edwards \eqn{T_{run}} test statistic based on the sum of the number of successive 
cases from each cases until a control is encountered in the data for detecting rare large clusters.

\eqn{T_{run}} test statistic is defined as \eqn{T_{run}=\sum_{i=1}^n \delta_i d_i^r} where \eqn{\delta_i=1} 
if \eqn{z_i} is a case, and 0 if \eqn{z_i} is a control and \eqn{d_i^r} is the number successive cases encountered beginning
at \eqn{z_i} until a control is encountered. 
 
The argument \code{cc.lab} is case-control label, 1 for case, 0 for control, if the argument \code{case.lab} is \code{NULL},
then \code{cc.lab} should be provided in this fashion, if \code{case.lab} is provided, the labels are converted to 0's and 1's
accordingly.

See also (\insertCite{cuzick:1990;textual}{nnspat}) and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(0:1,n,replace = TRUE)  #or try cls<-rep(0:1,c(10,10))

ceTrun(Y,cls)
ceTrun(Y,cls,method="max")
ceTrun(Y,cls+1,case.lab = 2)

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ceTrun(Y,fcls,case.lab="a") #try also ceTrun(Y,fcls)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:4,n,replace = TRUE)  #here ceTrun(Y,cls) #gives an error message

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ceTk}}, \code{\link{Tcomb}} and \code{\link{ceTkinv}}
}
\author{
Elvan Ceyhan
}
