% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsZdir.nnct}
\alias{funsZdir.nnct}
\alias{Zdir.nnct.ct}
\alias{Zdir.nnct}
\title{Directional Segregation Test for Two Classes with Normal Approximation}
\usage{
Zdir.nnct.ct(
  ct,
  covN,
  type = "II",
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)

Zdir.nnct(
  dat,
  lab,
  type = "II",
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{ct}{The NNCT, used in \code{Zdir.nnct.ct} only}

\item{covN}{The \eqn{k^2 \times k^2} covariance matrix of row-wise vectorized entries of NNCT}

\item{type}{The type of the directional (i.e. one-sided) test with default=\code{"II"}.
Takes on values \code{"I"} and \code{"II"} for types I and II directional tests (see the description above).}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, 
for the difference in phat estimates in the NNCT}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{Zdir.nnct} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{Zdir.nnct} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
used in \code{Zdir.nnct} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The \eqn{Z} test statistic for the directional (i.e. one-sided) test of segregation based on
the NNCT}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding alternative}
\item{conf.int}{Confidence interval for the difference in phat values in an NNCT
at the given confidence level \code{conf.level} and depends on the type of \code{alternative}.} 
\item{estimate}{Estimate of the parameter, i.e., the observed difference in phat values in an NNCT.}
\item{null.value}{Hypothesized null value for the difference in phat values in an NNCT
which is \eqn{-1/(n-1)} for this function.}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{ct.name}{Name of the contingency table, \code{ct}, returned by \code{Zdir.nnct.ct} only}
\item{data.name}{Name of the data set, \code{dat}, returned by \code{Zdir.nnct} only}
}
\description{
Two functions: \code{Zdir.nnct.ct} and \code{Zdir.nnct}.

Both functions are objects of class \code{"htest"} but with different arguments (see the parameter list below).
Each one performs hypothesis tests of equality of the expected value of the the difference between the
phat estimates in a \eqn{2 \times 2} NNCT to the one under RL or CSR (which is \eqn{-1/(n-1)}) where
phat estimates are \eqn{N_{11}/n_1} and \eqn{N_{21}/n_2}.
That is, each performs directional (i.e. one-sided) tests based on the \eqn{2 \times 2} NNCT 
(i.e. have the appropriate asymptotic sampling distribution)
for completely mapped data.
(See \insertCite{ceyhan:jnps-NNCT-2010;textual}{nnspat} for more detail).

The one-sided (or directional) test has two types, specified with the type argument, with default
\code{type="II"}. The second type is 
\eqn{Z_{II}=(T_n-E T_n)/\sqrt{Var(T_n)}} where \eqn{T_n=N_{11}/n_1 - N_{21}/n_2}
(which is the difference between
phat values) and the first type is \eqn{Z_I=U_n T_n} where \eqn{U_n=\sqrt{n_1 n_2/(C_1 C_2)}}.
Each test is based on the normal approximation of the \eqn{Z_I} and \eqn{Z_{II}} based on the \eqn{2 \times 2} NNCT and
are due to \insertCite{ceyhan:jnps-NNCT-2010}{nnspat}.

Each function yields the test statistic, \eqn{p}-value for the
corresponding alternative, the confidence interval, sample estimate (i.e. observed value) and null
(i.e., expected) value for the difference in phat values which is \eqn{-1/(n-1)} for this function 
and method and name of the data set used.

The null hypothesis is that all \eqn{E[Z_{II}] = 0} and \eqn{E[Z_I]} converges to 0 as class sizes go to infinity (or
\eqn{T_n} has mean equal to \eqn{-1/(n-1)} where \eqn{n} is the data size.
}
\examples{
n<-20
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

Zdir.nnct(Y,cls)
Zdir.nnct.ct(ct,covN)

Zdir.nnct(Y,cls,alt="g")
Zdir.nnct.ct(ct,covN,type="I",alt="l")

Zdir.nnct(Y,cls,method="max")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
ct<-nnct(ipd,fcls)

Zdir.nnct(Y,fcls)
Zdir.nnct.ct(ct,covN)

#############
ct<-matrix(1:4,ncol=2) 
Zdir.nnct.ct(ct,covN) #gives an error message if ct is defined as ct<-matrix(1:9,ncol=3)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Zdir.nnct.ss.ct}}, \code{\link{Zdir.nnct.ss}}, \code{\link{overall.nnct.ct}}
and \code{\link{overall.nnct}}
}
\author{
Elvan Ceyhan
}
