% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsZnnsym2cl.ss}
\alias{funsZnnsym2cl.ss}
\alias{Znnsym2cl.ss.ct}
\alias{Znnsym2cl.ss}
\title{Pielou's First Type of NN Symmetry Test with Normal Approximation for Two Classes
(for Sparse Sampling)}
\usage{
Znnsym2cl.ss.ct(
  ct,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95
)

Znnsym2cl.ss(
  dat,
  lab,
  alternative = c("two.sided", "less", "greater"),
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{ct}{A nearest neighbor contingency table, used in \code{Znnsym2cl.ss.ct} only}

\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"} or \code{"greater"}.}

\item{conf.level}{Level of the upper and lower confidence limits, default is \code{0.95}, 
for the difference of the off-diagonal entries, \eqn{N_{12}-N_{21}}}

\item{dat}{The data set in one or higher dimensions, each row corresponds to a data point,
used in \code{Znnsym2cl.ss} only}

\item{lab}{The \code{vector} of class labels (numerical or categorical), used in \code{Znnsym2cl.ss} only}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.
used in \code{Znnsym2cl.ss} only}
}
\value{
A \code{list} with the elements
\item{statistic}{The \eqn{Z} test statistic for Pielou's first type of NN symmetry test}
\item{p.value}{The \eqn{p}-value for the hypothesis test for the corresponding alternative}
\item{conf.int}{Confidence interval for the difference of the off-diagonal entries, \eqn{N_{12}-N_{21}} in the \eqn{2 \times 2} NNCT
at the given confidence level \code{conf.level} and depends on the type of \code{alternative}.}
\item{estimate}{Estimate, i.e., the difference of the off-diagonal entries of the \eqn{2 \times 2} NNCT, \eqn{N_{12}-N_{21}}.}
\item{null.value}{Hypothesized null value for the expected difference between the off-diagonal entries, 
\eqn{E(N_{12})-E(N_{21})} in the \eqn{2 \times 2} NNCT, which is 0 for this function.}
\item{alternative}{Type of the alternative hypothesis in the test, one of \code{"two.sided"}, \code{"less"}, \code{"greater"}}
\item{method}{Description of the hypothesis test}
\item{data.name}{Name of the data set, \code{dat}, or name of the contingency table, \code{ct}}
}
\description{
Two functions: \code{Znnsym2cl.ss.ct} and \code{Znnsym2cl.ss}.

Both functions are objects of class \code{"htest"} but with different arguments (see the parameter list below).
Each one performs hypothesis tests of equality of the expected value of the off-diagonal 
cell counts (i.e., entries) under RL or CSR in the NNCT for \eqn{k=2} classes.
That is, each performs Pielou's first type of NN symmetry test which is appropriate 
(i.e. have the appropriate asymptotic sampling distribution)
provided that data is obtained by sparse sampling.
(See \insertCite{ceyhan:SWJ-spat-sym2014;textual}{nnspat} for more detail).

Each symmetry test is based on the normal approximation of the difference of the off-diagonal entries
in the NNCT and are due to \insertCite{pielou:1961;textual}{nnspat}.

Each function yields the test statistic, \eqn{p}-value for the
corresponding alternative, the confidence interval, estimate and null value for the parameter of interest
(which is the difference of the off-diagonal entries in the NNCT), and method and name of the data set used.

The null hypothesis is that \eqn{E(N_{12})=E(N_{21})} in the \eqn{2 \times 2} NNCT (i.e., symmetry in the 
mixed NN structure).
In the output, the test statistic, \eqn{p}-value and the confidence interval are valid only 
for (properly) sparsely sampled data.

See also
(\insertCite{pielou:1961,ceyhan:SWJ-spat-sym2014;textual}{nnspat})
and the references therein.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)
ct

Znnsym2cl.ss(Y,cls)
Znnsym2cl.ss.ct(ct)

Znnsym2cl.ss(Y,cls,method="max")

Znnsym.ss.ct(ct)

Znnsym2cl.ss(Y,cls,alt="g")
Znnsym2cl.ss.ct(ct,alt="g")

#cls as a factor
na<-floor(n/2); nb<-n-na
fcls<-rep(c("a","b"),c(na,nb))
Znnsym2cl.ss(Y,fcls)

#############
ct<-matrix(sample(1:20,4),ncol=2)
Znnsym2cl.ss.ct(ct) #gives an error message if ct<-matrix(sample(1:20,9),ncol=3)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Xsq.nnsym.ss.ct}}, \code{\link{Xsq.nnsym.ss}}, \code{\link{Znnsym.ss.ct}} and
\code{\link{Znnsym.ss}}
}
\author{
Elvan Ceyhan
}
