% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_integration.R
\name{backend_dbplyr_v1}
\alias{backend_dbplyr_v1}
\alias{db_explain.AthenaConnection}
\alias{db_query_fields.AthenaConnection}
\title{Athena S3 implementation of dbplyr backend functions (api version 1).}
\usage{
db_explain.AthenaConnection(con, sql, ...)

db_query_fields.AthenaConnection(con, sql, ...)
}
\arguments{
\item{con}{A \code{\link{dbConnect}} object, as returned by \code{dbConnect()}}

\item{sql}{SQL code to be sent to AWS Athena}

\item{...}{other parameters, currently not implemented}
}
\value{
\describe{
\item{db_explain}{Returns \href{https://docs.aws.amazon.com/athena/latest/ug/athena-explain-statement.html}{AWS Athena explain statement}}
\item{db_query_fields}{Returns sql query column names}
}
}
\description{
These functions are used to build the different types of SQL queries. 
The AWS Athena implementation give extra parameters to allow access the to standard DBI Athena methods. They also
utilise AWS Glue to speed up sql query execution.
}
