% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{docdb_create}
\alias{docdb_create}
\title{Create documents}
\usage{
docdb_create(src, key, value, ...)
}
\arguments{
\item{src}{source object, result of call to an \link{src} function}

\item{key}{(chartacter) A key. ignored for mongo}

\item{value}{(data.frame) A single data.frame}

\item{...}{Ignored}
}
\description{
Create documents
}
\details{
Note that with etcd, you have to prefix a key with a
forward slash.
}
\examples{
\dontrun{
# CouchDB
src <- src_couchdb()
docdb_create(src, key="mtcars2", value=mtcars)
docdb_get(src, "mtcars2")

# etcd
# src <- src_etcd()
# docdb_create(src, key = "/newmtcars7", value = mtcars)
# docdb_get(src, "/newmtcars7")

# Elasticsearch
src <- src_elastic()
docdb_create(src, key = "mtcars", value = mtcars)
docdb_create(src, key = "iris", value = iris)
docdb_create(src, key = "diamonds_small", value = diamonds[1:3000L,])

# Redis
src <- src_redis()
docdb_create(src, key = "mtcars", value = mtcars)
docdb_get(src, "mtcars")
docdb_delete(src, "mtcars")

# MongoDB
src <- src_mongo()
docdb_create(src, key = "mtcars", value = mtcars)
docdb_get(src, "mtcars")
}
}
