% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_elasticsearch.R
\name{src_elastic}
\alias{src_elastic}
\title{Setup an Elasticsearch database connection}
\usage{
src_elastic(
  host = "127.0.0.1",
  port = 9200,
  path = NULL,
  transport_schema = "http",
  user = NULL,
  pwd = NULL,
  force = FALSE,
  ...
)
}
\arguments{
\item{host}{(character) the base url, defaults to localhost
(http://127.0.0.1)}

\item{port}{(character) port to connect to, defaults to 9200 (optional)}

\item{path}{(character) context path that is appended to the end of the
url. Default: \code{NULL}, ignored}

\item{transport_schema}{(character) http or https. Default: http}

\item{user}{(character) User name, if required for the connection. You
can specify, but ignored for now.}

\item{pwd}{(character) Password, if required for the connection. You can
specify, but ignored for now.}

\item{force}{(logical) Force re-load of connection details}

\item{...}{Further args passed on to \code{\link[elastic:connect]{elastic::connect()}}}
}
\value{
A \code{nodbi} source object
}
\description{
Setup an Elasticsearch database connection
}
\details{
Uses \pkg{elastic} as backend. \pkg{nodbi} creates or uses
an Elasticsearch index, in which \code{nodbi} creates JSON documents.
Any root-level \verb{_id} is extracted from the document(s) and used as
document ID \verb{_id}, otherwise a UUID is created as document ID \verb{_id}.
Only lowercase is accepted for container names (in parameter \code{key}).
Opensearch can equally be used.
For a benchmark, see \url{https://github.com/ropensci/nodbi#benchmark}
}
\examples{
\dontrun{
con <- src_elastic()
print(con)
}
}
