% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_equal_alignment.R
\name{create_equal_alignment}
\alias{create_equal_alignment}
\title{function create an alignment with identical information content}
\usage{
create_equal_alignment(
  input_tree,
  sub_rate,
  alignment_result,
  sim_function = NULL,
  verbose = FALSE,
  node_time = NULL,
  input_alignment_type = "nodesub"
)
}
\arguments{
\item{input_tree}{phylogeny for which to generate alignment}

\item{sub_rate}{substitution rate used in the original phylogeny}

\item{alignment_result}{result of sim_normal, sim_linked or sim_unlinked}

\item{sim_function}{function that accepts a tree, sequence length,
rootsequence and substitution rate (in that order). Default is sim_normal}

\item{verbose}{provide intermediate output}

\item{node_time}{node time}

\item{input_alignment_type}{was the input alignment simulated with a node
substitution model or a normal substitution model? Used to calculate the
twin mutation rate. Options are "nodesub" and "normal".}
}
\value{
list with four properties: 1) alignment: the alignment itself,
2) adjusted rate: the substitution rate used to obtain identical information
content 3) total_accumulated_substitutions: the total number of
substitutions accumulated. 4) total_node_substitutions: total number of
substitutions accumulated on the nodes 5) total_branch_substitutions: total
number of substitutions accumulated on the branches.
}
\description{
function create an alignment with identical information content
}
