% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/nomclust.R
\name{nomclust}
\alias{nomclust}
\title{Nominal Clustering}
\usage{
nomclust(data, measure = iof, clu_low = 2, clu_high = 6, eval = TRUE,
  prox = FALSE, method = "complete")
}
\arguments{
\item{data}{data frame or a matrix with cases in rows and variables in colums. Cases are characterized by nominal (categorical) variables coded as numbers.}

\item{measure}{character string defining the similarity measure which wil be used for computation of proximity matrix:
\code{"eskin"}, \code{"good1"}, \code{"good2"}, \code{"good3"}, \code{"good4"}, \code{"iof"}, \code{"lin"}, \code{"lin1"}, \code{"morlini"}, \code{"of"}, \code{"sm"}.}

\item{clu_low}{numeric value expressing the lower bound for number of cluster solutions.}

\item{clu_high}{numeric value expressing the higher bound for number of cluster solutions.}

\item{eval}{logical operator; if TRUE, there is performed an evaluation of clustering results}

\item{prox}{logical operator; if TRUE, the proximity matrix is a part of the output}

\item{method}{character string defining the clustering method. The following methods can be used: \code{"average"}, \code{"complete"}, \code{"single"}.}
}
\value{
Function returns a list following components:
\cr
\cr
\code{mem}  data frame consisting of cluster membership variables
\cr
\cr
\code{eval} data frame containing clustering evaluation statistics
\cr
\cr
\code{prox} matrix containing proximities between all combination of pairs of objects (voluntary)
}
\description{
The Nominal Clustering (nomclust) performs hierarchical cluster analysis (HCA) with objects characterized by nominal (categorical) variables.
It performs a serie of cluster solutions, usually from two-cluster solution till six-cluster solution.
It allows to choose one from 11 different similarity measures and one from 3 linkage methods. The function
also contains an evaluation part. The created clusters are evaluated from a point of view of the
within-cluster variability by the following indices: Within-cluster Mutability coefficient (\code{WCM}),
Within-cluster entropy coefficient (\code{WCE}), Pseudo tau coefficient (\code{PSTau}), Pseudo uncertainty coefficient (\code{PSU}) and Pseudo F
Indices based on the mutability (\code{PSFM}) and the entropy (\code{PSFE}).
}
\examples{
#sample data
data(data20)
hca <- nomclust(data20, iof, method = "average", clu_high = 5, prox = TRUE)
#getting evaluation statistics
eval <- hca$eval
#getting cluster membership variables
mem <- hca$mem
#getting a proximity matrix
prox <- hca$prox
}
\seealso{
\code{\link[nomclust]{evalclust}}, \code{\link[cluster]{agnes}}.
}

