% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalclust.R
\name{evalclust}
\alias{evalclust}
\title{Evaluation of the Clustering}
\usage{
evalclust(data, num_var, clu_low = 2, clu_high = 6)
}
\arguments{
\item{data}{data frame or matrix with cases in rows and variables in colums. First \code{m1} variables are the
original data used for clustering, the next \code{m2} variables express the cluster memberships in an increasing
way (e.g. from clu_2 to clu_6).}

\item{num_var}{numeric value which determines how many variables in a dataset were used for the clustering.}

\item{clu_low}{numeric value expressing the lower bound for number of cluster solutions.}

\item{clu_high}{numeric value expressing the higher bound for number of cluster solutions.}
}
\value{
Function returns a data frame, where the rows express a serie of cluster solutions and columns
clustering evaluation statistics in a following order: \code{WCM}, \code{WCE}, \code{PSTau}, \code{PSU}, \code{PSFM}, \code{PSFE}.
}
\description{
The function evaluates clustering results no matter which clustering method they were obtained by.
The clusters are evaluated from a point of view of the within-cluster variability by the following indices:
Within-cluster mutability coefficient (WCM), Within-cluster entropy coefficient (WCE),
Pseudo tau coefficient (PSTau), Pseudo uncertainty coefficient (PSU) and Pseudo F, Indices based on the mutability (PSFM) and the entropy (PSFE).
}
\examples{
#sample data
data(data20)
#creation of a dataset with cluster memberships
data_clu <- nomclust(data20, iof, clu_high = 7)
#binding an original dataset to cluster memberships variables
data_clu2 <- cbind(data20, data_clu$mem)
#evaluation of created clusters
evaluation <- evalclust(data_clu2, 5, clu_high = 7)

}
\seealso{
\code{\link[nomclust]{nomclust}}.
}
