% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/undir.R
\name{NOSM_undir}
\alias{NOSM_undir}
\title{Compute NOS using an undirected network without a user provided
network of potential interactions}
\usage{
NOSM_undir(net, perc = 1, sl = 1)
}
\arguments{
\item{net}{A network, in the form of an edge list. This should be a matrix or
dataframe with two columns. Each value in a column is a node. Nodes can be
identified using numbers or characters. Data can also be in the format of a
frequency interaction matrix, as used in the \link[bipartite]{bipartite} R
package. In these cases \code{\link{freqMat_2_edge}} should be used first,
to convert the interaction matrix to an edge list.}

\item{perc}{(default to 1) - the fraction of node pair comparisons to be
performed to compute NOS. We recommend performing all possible pair
comparisons (perc = 1). However, for exploratory analyses on large sets of
networks (or for very large networks), the possibility of using a lower
fraction of pair comparisons is a useful option.}

\item{sl}{(default is 1) Specifies whether cannibalistic interactions should
be considered as possible and therefore taken into account and removed
during computation ('1') or not ('0').}
}
\value{
A list of class 'NOSM' with a 'Type' attribute 'Undir', containing a
  vector of overlap values. The \code{\link{summary.NOSM}} methods provides
  more useful summary statistics.
}
\description{
Computation of NOS using an undirected network (e.g. a
  social co-occurence network) and without a user provided network of potential
  interactions. In an undirected network, all nodes are considered as
  potential interacting partners.
}
\examples{
data(boreal)
y <-  boreal[sample(rownames(boreal), 100, FALSE),] #subset 100 rows for speed
x <- NOSM_undir(y, perc = 1, sl = 1)
summary(x)
}
