"nparcomp" <-
function(formula,
data,
type=c("Tukey", "Dunnett", "Sequen", "Williams", "Changepoint", "AVE", "McDermott", "Marcus"),
control = NULL,

conflevel=0.95,
alternative=c("two.sided","lower","greater"),
rounds=3,
Correlation = FALSE,
asy.method=c("logit","probit", "normal", "mult.t"),
plot.simci = TRUE,
info = TRUE
 )
    {

mvtnorm <- require(mvtnorm, quietly = TRUE)
multcomp <- require(multcomp, quietly = TRUE)



corr.mat <- function(m,nc) {
      rho <- matrix(c(0),ncol=nc,nrow=nc)
      for (i in 1:nc) {
          for (j in 1:nc) {
              rho[i,j]<-m[i,j]/sqrt(m[i,i]*m[j,j])
            }
          }
        return(rho)
    }

ssq <- function(x) {sum(x * x) }

logit <- function(p) { log(p/(1-p))  }

probit <- function(p) { qnorm(p)}

expit <- function(G){exp(G)/(1+exp(G))}



index <- function (char,test) {
      nc<-length(char)
      for ( i in  1:nc) {
      if (char[i] == test) {return(i)} }}

z.quantile <- function(conflevel=conflevel,corr,a,df=df.sw, dbs) {
      if (dbs=="n"){
      if (a == "two.sided"){
      z <- qmvnorm(conflevel,corr=corr, tail = "both")$quantile}
      if (a == "lower" || a == "greater") {
      z <- qmvnorm(conflevel,corr=corr, tail = "lower")$quantile} }
      if ( dbs=="t") {
      if ( a == "two.sided") {
      z <- qmvt(conflevel, df = df.sw, interval=c(-10,10), corr= corr, tail = "both")$quantile}
      if (a == "lower" || a == "greater") {
      z <-  qmvt(conflevel, df = df.sw, interval=c(-10,10), corr=corr, tail = "lower")$quantile}
                    }
      return(z)
      }



if (conflevel >= 1 || conflevel <= 0) {
      stop ("The confidence level must be between 0 and 1!")
if (is.null(alternative)){stop("Please declare the alternative! (two.sided, lower, greater)")}                                      }
      type <- match.arg(type)
      alternative <- match.arg(alternative)
      asy.method <- match.arg(asy.method)



    if (length(formula)!=3){stop("You can only analyse one-way layouts!")}
    dat <- model.frame(formula, data)
    if (ncol(dat) != 2) {
        stop("Specify one response and only one class variable in the formula")
    }
    if (is.numeric(dat[, 1]) == FALSE) {
        stop("Response variable must be numeric") }
    response <- dat[, 1]
    factorx <- as.factor(dat[, 2])

    fl <- levels(factorx)
    a <- nlevels(factorx)
    if (a <=2){ stop("You want to perform a two-sample test. Please use the function npar.t.test")}
    samples <- split(response, factorx)
    n <- sapply(samples, length)

    if (any(n==1)) {warn<- paste("The factor level", fl[n==1], "has got only one observation!")
                    stop(warn)}
    ntotal <- sum(n)
    a <- length(n)

    tmp <- expand.grid(1:a, 1:a)
        ind <- tmp[[1]] > tmp[[2]]
        vi <- tmp[[2]][ind]
        vj <- tmp[[1]][ind]
      nc <- length(vi)

    gn <- n[vi] + n[vj]
    intRanks <- lapply(samples, rank)
pairRanks <- lapply (1:nc, function(arg)
    {
      rank(c(samples[[vi[arg]]], samples[[vj[arg]]]))
    })

pd <- sapply(1:nc, function(arg)
    {
      i <- vi[arg]
      j <- vj[arg]
      (sum(pairRanks[[arg]][(n[i] + 1):gn[arg]])/n[j] - (n[j] + 1)/2)/n[i]
    })

      dij <- dji <- list(0)
sqij <- sapply(1:nc, function(arg)
    {
      i <- vi[arg]
      j <- vj[arg]
      pr <- pairRanks[[arg]][(n[i] + 1):gn[arg]]
      dij[[arg]] <<- pr - sum(pr)/n[j] - intRanks[[j]] + (n[j] + 1)/2
        ssq(dij[[arg]])/(n[i] * n[i] * (n[j] - 1))
    })
sqji <- sapply(1:nc, function(arg)
    {
      i <- vi[arg]
      j <- vj[arg]
      pr <- pairRanks[[arg]][1:n[i]]
      dji[[arg]] <<- pr - sum(pr)/n[i] - intRanks[[i]] + (n[i] + 1)/2
      ssq(dji[[arg]])/(n[j] * n[j] * (n[i] - 1))
    })
      vd.bf <- ntotal *(sqij/n[vj] + sqji/n[vi])

      singular.bf <- (vd.bf == 0)
      vd.bf[singular.bf] <- 0.00001


      df.sw <- (n[vi] * sqij + n[vj] * sqji)^2/((n[vi] * sqij)^2/(n[vj] -
      1) + (n[vj] * sqji)^2/(n[vi] - 1))
      lambda <- sqrt(n[vi]/(gn + 1))


      cov.bf1 <- diag(nc)
      rho.bf  <- diag(nc)
      for (x in 1:(nc - 1)) {
        for (y in (x + 1):nc) {
            i <- vi[x]
            j <- vj[x]
            v <- vi[y]
            w <- vj[y]
            p <- c(i == v, j == w, i == w, j == v)
            if (sum(p) == 1) {
                cl <- list (
                function()
                (t(dji[[x]]) %*% dji[[y]])/(n[j] *
                n[w] * n[i] * (n[i] - 1)),
                function() (t(dij[[x]]) %*%
                dij[[y]])/(n[i] * n[v] * n[j] * (n[j] - 1)),
                function() -(t(dji[[x]]) %*% dij[[y]])/(n[v] *
                n[j] * n[i] * (n[i] - 1)),
                function() -(t(dij[[x]]) %*%
                dji[[y]])/(n[i] * n[w] * n[j] * (n[j] - 1)))
                case <- (1:4)[p]
                rho.bf[x, y] <- rho.bf[y, x] <- sqrt(ntotal *
                ntotal)/sqrt(vd.bf[x] * vd.bf[y]) * cl[[case]]()
                cov.bf1[x, y] <- cov.bf1[y, x] <- sqrt(vd.bf[x]*vd.bf[y])

            }
        }
    }

      cov.bf <- (cov.bf1+diag(vd.bf-1))*rho.bf




switch(
        type,
Tukey = {
      if (is.null(control)) {
      nc <- a*(a-1)/2
      cmpid  <- sapply(1:nc, function(arg)
    {
      i <- vi[arg]
      j <- vj[arg]
       paste ("p","(",fl[i],",",fl[j],")",sep="")
    })
    weight.help <- (vj < vi)
    weight <- weight.matrix(n,"Tukey")
        }
    else{ stop ("The Tukey contrast hasn't got a control group!")}
    type.of.contrast <- "Tukey"
          },
Dunnett = {
      nc <- a-1
      if (is.null(control)){cont <- 1}
      else {
      if (!any(fl == control)){stop("The dataset doesn't contain this control group!")}
      cont <- which(fl == control) }
      vj <- which((1:a) != cont)
      vi <- rep(cont, a - 1)
      weight <- weight.matrix(n, "Dunnett", cont)
      cmpid  <- sapply(1:nc, function(arg)
      {
      i <- vi[arg]
      j <- vj[arg]
      paste ("p","(",fl[i],",",fl[j],")",sep="")
      })
      weight.help <- (vj < vi)
      type.of.contrast <- "Dunnett"
      } ,
Sequen = {
      if (is.null(control)) {
      nc <- a-1
      vi<-1:(a-1)
      vj<-2:a
      weight <- weight.matrix(n, "Sequen")
      cmpid  <- sapply(1:nc, function(arg)
        {
      i <- vj[arg]
      j <- vi[arg]
      paste ("p","(",fl[j],",",fl[i],")",sep="")
        })
      weight.help <- (vj < vi)
      type.of.contrast <- "Sequen"
      }
      else{ stop ("The Sequen-Contrast hasn't got a control group!")}},

Williams = {
      if (is.null(control)) {
      nc <- a-1
      weight <- weight.matrix(n, "Williams")
      cmpid <-paste ("C", 1:(a-1))
      weight.help <- 0
      type.of.contrast <- "Williams"
      }
      else{ stop ("The Williams-Contrast hasn't got a control group!")}},
      Changepoint = {
      if (is.null(control)) {
      nc <- a-1
      weight <- weight.matrix(n, "Changepoint")
      cmpid <-paste ("C", 1:(a-1))
      weight.help <- 0
      type.of.contrast <- "Changepoint"
      }
      else{ stop ("The Changepoint-Contrast hasn't got a control group!")}
      },
      AVE = {
      if (is.null(control)) {
      nc <- a
      weight <- weight.matrix(n, "AVE")
      cmpid <-paste ("C", 1:a)
      weight.help <- 0
      type.of.contrast <- "Average"
      }
      else{ stop ("The Average-Contrast hasn't got a control group!")}
      },
McDermott = {
      if (is.null(control)) {
      nc <- a-1
      weight <- weight.matrix(n, "McDermott")
      cmpid <-paste ("C", 1:(a-1))
      weight.help <- 0
      type.of.contrast <- "McDermott"
      }
      else{ stop ("The McDermott-Contrast hasn't got a control group!")}
      },
Marcus = {
      if (is.null(control)) {
      nc <- a*(a-1)/2
      weight <- weight.matrix(n, "Marcus")

      cmpid <-paste ("C", 1:(a*(a-1)/2))
      weight.help <- 0
      type.of.contrast <- "Marcus"
      }
      else{ stop ("The Marcus-Contrast hasn't got a control group!")}
      }
      )


pd <- abs (weight %*% pd - weight.help)
pd1 <- (pd == 1)
pd0 <- (pd == 0)
pd[pd1] <- 0.999
pd[pd0] <- 0.001


cov.bf <- weight %*% cov.bf %*% t(weight)
for (i in 1:nc){ if (cov.bf[i,i] ==0){cov.bf[i,i]<-0.001}}
vd.bf <- c(diag(cov.bf))
vd.bf <- c(vd.bf)




rho.bf <- corr.mat(cov.bf,nc)
t.bf <- sqrt(ntotal) *(pd-1/2)/sqrt(vd.bf)



rownames(weight) <- paste ("C", 1:nc)
ncomp <- a*(a-1)/2
tmp <- expand.grid(1:a, 1:a)
      ind <- tmp[[1]] > tmp[[2]]
      v2 <- tmp[[2]][ind]
      v1 <- tmp[[1]][ind]
      namen  <- sapply(1:ncomp, function(arg)
    {
      i <- v2[arg]
      j <- v1[arg]
       paste ("p","(",fl[i],",",fl[j],")",sep="")
    })
    colnames(weight) <- namen


df.sw[is.nan(df.sw)] <- 1000
df.sw <- weight %*% df.sw
df.sw <- max(1,min(df.sw))




      pd<-c(pd)
      logit.pd<-logit(pd)
      logit.dev<-diag(1/(pd*(1-pd)))
      logit.cov<-logit.dev%*%cov.bf%*%t(logit.dev)
      vd.logit<-c(diag(logit.cov))
      t.logit <- (logit.pd) * sqrt(ntotal/vd.logit)



      probit.pd<-qnorm(pd)
      probit.dev<-diag(sqrt(2*pi)/(exp(-0.5*qnorm(pd)*qnorm(pd))))
      probit.cov<-probit.dev%*%cov.bf%*%t(probit.dev)
      vd.probit<-c(diag(probit.cov))
      t.probit <- (probit.pd) * sqrt(ntotal/vd.probit)








      p.bfn  = p.bft = p.bflogit = p.bfprobit = c()
      if (alternative=="two.sided"){
      z.bft <- z.quantile(conflevel=conflevel,corr=rho.bf,"two.sided",df=df.sw,dbs="t")
      z.bfn <- z.quantile(conflevel=conflevel,corr=rho.bf,"two.sided",df=0,dbs="n")

      lower.bft <- pd-sqrt(vd.bf / ntotal)*z.bft
      upper.bft <- pd+sqrt(vd.bf / ntotal)*z.bft
      lower.bfn <- pd-sqrt(vd.bf / ntotal)*z.bfn
      upper.bfn <- pd+sqrt(vd.bf / ntotal)*z.bfn
      lower.logit <- expit(logit.pd-sqrt(vd.logit/ntotal)*z.bfn)
      upper.logit <- expit(logit.pd+sqrt(vd.logit/ntotal)*z.bfn)
      lower.probit <- pnorm(probit.pd-sqrt(vd.probit/ntotal)*z.bfn)
      upper.probit <- pnorm(probit.pd+sqrt(vd.probit/ntotal)*z.bfn)

      for (i in 1:nc){
      p.bfti <- pmvt(lower=-Inf,upper=abs( t.bf[i]), delta=rep(0,nc),
               df=df.sw, corr=rho.bf)
      p.bft[i] <- min (2-2*p.bfti,
                  max(1-pmvt(lower=-Inf,upper=t.bf[i], delta=rep(0,nc),
                  df=df.sw, corr=rho.bf), pmvt(lower=-Inf,upper=t.bf[i],
                  delta=rep(0,nc),
                  df=df.sw, corr=rho.bf)))
      p.bfni <- pmvnorm(lower=-Inf, upper= abs(t.bf[i]),mean=rep(0,nc),corr=rho.bf)
      p.bflogiti <- pmvnorm(lower=-Inf, upper= abs(t.logit[i]),mean=rep(0,nc),corr=rho.bf)
      p.bfprobiti <- pmvnorm(lower=-Inf, upper= abs( t.probit[i]),mean=rep(0,nc),corr=rho.bf)
      p.bfn[i] <- min(2-2*p.bfni,
                  max(1-pmvnorm(lower=-Inf,upper=t.bf[i], mean=rep(0,nc),corr=rho.bf),
                  pmvnorm(lower=-Inf,upper=t.bf[i],mean=rep(0,nc), corr=rho.bf)))
      p.bflogit[i] <- min (2-2*p.bflogiti,
      max(1-pmvnorm(lower=-Inf,upper=t.logit[i], mean=rep(0,nc),corr=rho.bf),
      pmvnorm(lower=-Inf,upper=t.logit[i],
      mean=rep(0,nc), corr=rho.bf)))
      p.bfprobit[i]<- min (2-2*p.bfprobiti,
      max(1-pmvnorm(lower=-Inf,upper=t.probit[i], mean=rep(0,nc),corr=rho.bf),
      pmvnorm(lower=-Inf,upper=t.probit[i],
      mean=rep(0,nc), corr=rho.bf)))
                       }


      text.output.p<-"H_0: p(i,j)=1/2"
      text.output.KI<-paste(100*conflevel,"%","2-sided","Simultaneous-Confidence-Intervals for Relative Effects")
      upper <- "]"
      lower <- "["
                    }



      if (alternative=="lower"){
      z.bft    <- z.quantile(conflevel=conflevel,corr=rho.bf,"lower",df=df.sw, dbs="t")
      z.bfn    <-  qmvnorm(conflevel,corr=rho.bf, tail = "lower")$quantile

      lower.bft <- pd-sqrt(vd.bf/ntotal)*z.bft
      lower.bfn <- pd-sqrt(vd.bf/ntotal)*z.bfn
      lower.logit<-expit(logit.pd-sqrt(vd.logit/ntotal)*z.bfn)
      lower.probit<-pnorm(probit.pd-sqrt(vd.probit/ntotal)*z.bfn)
      upper.bft = upper.probit= upper.logit = upper.bfn = 1

      for (i in 1:nc) {
      p.bfn[i]<-1-pmvnorm(lower=-Inf , upper=abs(t.bf[i]),mean=rep(0,nc),corr=rho.bf)
      p.bft[i] <- 1-pmvt(lower= -Inf, upper= t.bf[i], delta=rep(0,nc),
               df=df.sw, corr=rho.bf)
      p.bflogit[i] <- 1-pmvnorm(lower=-Inf, upper= t.logit[i],mean=rep(0,nc),corr=rho.bf)
      p.bfprobit[i]<-1-pmvnorm(lower=-Inf , upper=t.probit[i],mean=rep(0,nc),corr=rho.bf)
                       }

      text.output.p<-"H_0: p(i,j)<=1/2"
      text.output.KI<-paste(100*conflevel,"%","1-sided","Simultaneous-Confidence-Intervals for Relative Effects")
      upper <- "]"
      lower <- "("
                              }


      if (alternative=="greater") {
      z.bft <- z.quantile(conflevel=conflevel,corr=rho.bf,"lower",df=df.sw, dbs="t")
      z.bfn <- z.quantile(conflevel=conflevel,corr=rho.bf,"lower",df=0,dbs="n")

      upper.bft<-pd+sqrt(vd.bf/ntotal)*z.bft
      upper.bfn<-pd+sqrt(vd.bf/ntotal)*z.bfn
      upper.logit<-expit(logit.pd+sqrt(vd.logit/ntotal)*z.bfn)
      upper.probit<-pnorm(probit.pd+sqrt(vd.probit/ntotal)*z.bfn)
      lower.bft = lower.probit= lower.logit = lower.bfn = 0

      for (i in 1:nc) {
      p.bfn[i]<-1-pmvnorm(lower=t.bf[i], upper=Inf,mean=rep(0,nc),corr=rho.bf)
      p.bft[i]<-1-pmvt(lower=t.bf[i] , upper= Inf, delta=rep(0,nc),
               df=df.sw, corr=rho.bf)
      p.bflogit[i]<-1-pmvnorm(lower=t.logit[i], upper= Inf ,mean=rep(0,nc),corr=rho.bf)
      p.bfprobit[i]<-1-pmvnorm(lower=t.probit[i], upper=Inf ,mean=rep(0,nc),corr=rho.bf)
                      }
      text.output.p <- " H_0: p(i,j)>=1/2"
      text.output.KI <- paste(100*conflevel,"%","1-sided","Simultaneous-Confidence-Intervals for Relative Effects")
      upper <- ")"
      lower <- "["
                          }

      bfn.output <- paste(lower ,round(lower.bfn,rounds),";",round(upper.bfn,rounds),upper)
      bft.output <- paste(lower ,round(lower.bft,rounds),";",round(upper.bft,rounds), upper)
      logit.output <- paste(lower,round(lower.logit,rounds),";",round(upper.logit,rounds),upper)
      probit.output <- paste(lower ,round(lower.probit,rounds),";",round(upper.probit,rounds),upper)
      p.bflogit <- round(p.bflogit,rounds)
      p.bfprobit <- round(p.bfprobit,rounds)
      p.bft <- round(p.bft,rounds)
      p.bfn <- round(p.bfn,rounds)
      pd <- round(pd,rounds)



if (Correlation == TRUE){
  Correlation <- list (Correlation.matrix.N = rho.bf, Covariance.matrix.N = cov.bf, Warning = paste("Attention! The covariance matrix is multiplied with N","=",ntotal))}

  else {Correlation <- NA}

data.info <- data.frame(row.names=1:a,Sample = fl, Size = n)


switch(   asy.method,

logit = {
      x.werte = cbind (lower.logit, pd, upper.logit)
      result <- list ( weight.matrix = weight,
      Data.Info = data.info,
      Analysis.of.relative.effects =
      data.frame(row.names=c(1:nc),
      Comparison=cmpid,
      rel.effect = pd ,
      confidence.interval = logit.output,
      t.value = t.logit,
      p.value = p.bflogit),
      Mult.Distribution = data.frame(Quantil = z.bfn, p.Value.global = min(p.bflogit)),
      Correlation = Correlation)

      Asymptotic.Method <- "Multivariate Delta-Method (Logit)"},

probit = {
      x.werte = cbind (lower.probit, pd, upper.probit)
      result <- list( weight.matrix = weight,
            Data.Info = data.info,
      Analysis.of.relative.effects =
      data.frame(row.names=c(1:nc),
      Comparison=cmpid,
      rel.effect = pd,
      confidence.interval = probit.output,
      t.value =t.probit,
      p.value =p.bfprobit),
      Mult.Distribution = data.frame(Quantil = z.bfn, p.Value.global = min(p.bfprobit)),
      Correlation = Correlation )
      Asymptotic.Method <- "Multivariate Delta-Method (Probit)"} ,

normal = {
      x.werte = cbind (lower.bfn, pd, upper.bfn)
      result <- list( weight.matrix = weight,
      Data.Info = data.info,
      Analysis.of.relative.effects =
      data.frame ( row.names = c(1:nc),
      Comparison = cmpid,
      rel.effect = pd,
      confidence.interval=bfn.output,
      t.value = t.bf,
      p.value = p.bfn),
      Mult.Distribution = data.frame(Quantil = z.bfn, p.Value.global = min(p.bfn)),
      Correlation = Correlation)
      Asymptotic.Method <- "Multivariate Normal Distribution"},

mult.t = {
      x.werte = cbind (lower.bft, pd, upper.bft)
      result <- list(weight.matrix = weight,
      Data.Info = data.info,
      Analysis.of.relative.effects =
      data.frame ( row.names = c(1:nc),
      Comparison = cmpid,
      rel.effect = pd,
      confidence.interval = bft.output,
      t.value = t.bf,
      p.value =p.bft),
      Mult.Distribution = data.frame(Quantil = z.bft, p.Value.global = min(p.bft),d.f. = df.sw),
      Correlation = Correlation
     )

      Asymptotic.Method <- paste("Multi t - Distribution with d.f.= ",round(df.sw,4))}
)



if ( plot.simci == TRUE ) {

      test <- matrix(c(1:nc),ncol=nc,nrow=nc)
      angaben<-c(cmpid)
      angaben<-matrix(c(angaben),ncol=nc,nrow=nc)
      k<-c(1:nc)
      plot(x.werte[,2],k,xlim=c(0,1),axes = FALSE, type = "p",pch=15,xlab = "",ylab = "")
      abline(v=0.5,col="red",lty = 1, lwd = 2)
      axis(1, at =seq(0,1,0.1))
      axis(2, at = test, labels = angaben)
      axis(4,at = test, labels = test)


      points (x = x.werte[,3], y = test[,1],pch = upper )
      points(x = x.werte[,1], y = test[,1], pch = lower )
      for (i in 1:nc){
      polygon(c(x.werte[i,1],x.werte[i,3]),c(i,i))
      }
      box()

      title( main = c(text.output.KI, paste("Type of Contrast:","",type.of.contrast,sep=""),paste("Method:","", Asymptotic.Method,sep="")),
      ylab ="Comparison",
      xlab = paste("lower",lower,"-----","p","------",upper,"upper"))
                              }

      if (info == TRUE){
      cat("\n","", "Nonparametric Multiple Comparison Procedure based on relative contrast effects",",",
      "Type of Contrast", ":",type.of.contrast,"\n",
      "NOTE:","\n",
      "*-------------------Weight Matrix------------------*","\n",
      "-", "Weight matrix for choosen contrast based on all-pairs comparisons","\n","\n",
      "*-----------Analysis of relative effects-----------*","\n",
      "-", "Simultaneous Confidence Intervals for relative effects p(i,j)
      with confidence level",conflevel,"\n",
      "-","Method","=",Asymptotic.Method,"\n",
      "-","p-Values for ",text.output.p,"\n","\n",
      "*----------------Interpretation--------------------*","\n",
      "p(a,b)", ">", "1/2", ":", "b tends to be larger than a","\n",
      "*--------------Mult.Distribution-------------------*","\n",
      "-", "Equicoordinate Quantil","\n",
      "-", "Global p-Value","\n",
      "*--------------------------------------------------*","\n")}

return(result)


}

