% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/persimon.R
\name{persimon}
\alias{persimon}
\title{Performance Simulation On Type I Error or Statistical Power}
\usage{
persimon(
  M1 = 5,
  S1 = 1,
  M2 = 5,
  S2 = 1,
  M3 = 5,
  S3 = 1,
  Sk1 = NULL,
  Sk2 = NULL,
  Sk3 = NULL,
  n1 = c(2, 3, 4, 5, 6, 7, 8, 9, 10, 15),
  n2 = c(2, 3, 4, 5, 6, 7, 8, 9, 10, 15),
  n3 = c(2, 3, 4, 5, 6, 7, 8, 9, 10, 15),
  n_simulations = 10000,
  nboot = 1000,
  conf.level = 0.95
)
}
\arguments{
\item{M1}{Mean value for group 1.}

\item{S1}{Standard deviation for group 1.}

\item{M2}{Mean value for group 2.}

\item{S2}{Standard deviation for group 2.}

\item{M3}{Mean value for group 3.}

\item{S3}{Standard deviation for group 3.}

\item{Sk1}{Skewness parameter for group 1; NULL for normal distribution.}

\item{Sk2}{Skewness parameter for group 2; NULL for normal distribution.}

\item{Sk3}{Skewness parameter for group 3; NULL for normal distribution.}

\item{n1}{Vector of sample sizes for group 1.}

\item{n2}{Vector of sample sizes for group 2.}

\item{n3}{Vector of sample sizes for group 3.}

\item{n_simulations}{Number of simulations to run (default is 10000).}

\item{nboot}{Number of bootstrap samples (default is 1000).}

\item{conf.level}{Confidence level for the tests (default is 0.95).}
}
\value{
A list of data frames. One with the proportions of rejecting the null
hypothesis for each test and sample size combination, and the other with the
number of models which did not produce errors for each combination.
}
\description{
Simulates performance (Type I Error or Statistical Power) for a range of
statistical tests, including bootFbar, default setting restriktor::iht, and
parametric bootstrap restriktor::iht. The function is set up to replicate the
table structure in Dwivedi et al. (2017) Supplemental Tables 2 & 3.
}
\details{
The \code{persimon} function generates data for three groups with specified mean, standard deviation,
and skewness, and then applies a range of statistical tests to this data, simulating the process
across a specified number of iterations to assess performance in terms of Type I Error or
Statistical Power. The output mirrors the format of the supplemental tables in Dwivedi et al. (2017).
}
\examples{
set.seed(135)
persimon(M1 = 5, S1 = 1, M2 = 5, S2 = 1, M3 = 5, S3 = 1,
         n1 = 6, n2 = 6, n3 = 6, n_simulations = 2, nboot = 4,
         conf.level = 0.95)

}
\references{
Dwivedi, A. K., Mallawaarachchi, I., & Alvarado, L. A. (2017). Analysis of small sample size studies
using nonparametric bootstrap test with pooled resampling method. Statistics in Medicine, 36(14), 2187–2205.
https://doi.org/10.1002/sim.7263
}
