% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Phen.R
\encoding{UTF-8}
\name{Phen}
\alias{Phen}
\title{Phen}
\usage{
Phen(x, dates, h, frequency = "16-days", rge)
}
\arguments{
\item{x}{Numeric vector. A time series of a vegetation index (e.g. LAI, NDVI, EVI) or any other variable with seasonal behavior. The code has been optimized to work with integer values. Please re-scale the input values if necessary (e.g. NDVI ranging from 0.0000 to 1.0000, multiply by 10,000}

\item{dates}{A date vector. The number of dates must be equal to the number of "x" values (numeric input vector).}

\item{h}{Numeric. Indicates the geographic hemisphere to define the starting date of the growing season. h=1 if the vegetation is in the Northern Hemisphere (season starting at January 1st), h=2 if it is in the Southern Hemisphere (season starting at July 1st)}

\item{frequency}{Character string. Defines the number of samples for the output phenology and must be one of the this: 'daily' giving output vector of length 365, '8-days' giving output vector of length 46 (i.e MOD13Q1 and MYD13Q1), 'monthly' giving output vector of length 12,'bi-weekly' giving output vector of length 24 (i.e. GIMMS) or '16-days' (default) giving output vector of length 23 (i.e MOD13Q1 or MYD13Q1).}

\item{rge}{Numeric vector with two values setting the minimum and maximum values of the response variable (e.g. NDVI) used in the analysis. We suggest the use of theoretically based limits. For example in the case of MODIS NDVI or EVI, it ranges from 0 to 10,000, so rge = c(0,10000)}
}
\value{
A numeric vector, where each value represents the expected greeness at that date
}
\description{
Estimates the annual phenological cycle from a time series of vegetation greenness.
}
\details{
Derives the annual phenological cycle for a standard growing season using a numeric vector of vegetation canopy greenness values (e.g. Leaf Area Index, LAI) or satellite based greenness proxies such as the Normalized Difference Vegetation Index (NDVI) or Enhanced Vegetation Index (EVI). A vector with dates for the greenness values is also required.
}
\examples{
\dontshow{
## Testing function with time series of Nothofagus macrocarpa (NDVI)
# Load data
data("phents")
# Phenology for the given data
Phen(x=phents$NDVI,dates=phents$dates,h=2,frequency = '16-days',rge=c(0,10000))
}
\donttest{
library(lubridate)

## Testing raster data from Central Chile (NDVI), h=2##

# Load data
#RasterStack
data("MegaDrought_stack")
#Dates
data("modis_dates")

#Creates Raster time series using a raster stack and a date database from Central Chile
# Obtain data from a particular pixel generating a time series
md_pixel <- cellFromXY(MegaDrought_stack,c(313395,6356610))
md_pixelts <- as.numeric(MegaDrought_stack[md_pixel])
plot(modis_dates,md_pixelts, type='l')

# Phenology for the given pixel
Phen(x=md_pixelts,dates=modis_dates,h=2,frequency='16-days',rge=c(0,10000))

## Testing with the Bdesert_stack from the Atacama Desert, Northern Chile (NDVI), h=2 ##

# Load data
#RasterStack
data("Bdesert_stack")
#Dates
data("modis_dates")

#Creates Raster time series using a raster stack and a date database from Northern Chile
# Obtain data from a particular pixel generating a time series
bd_pixel<-cellFromXY(Bdesert_stack,c(286638,6852107))
bd_pixelts<-as.numeric(Bdesert_stack[bd_pixel])
plot(modis_dates,bd_pixelts, type = 'l')

# Phenology for the given pixel
Phen(x=bd_pixelts,dates=modis_dates,h=2,frequency='16-days',rge=c(0,10000))
}
}
\seealso{
\code{\link{PhenMap}},\code{\link{PhenKplot}}
}
