% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPotentialSires.R, R/getSimSires.R
\name{getPotentialSires}
\alias{getPotentialSires}
\title{Provides list of potential sires}
\usage{
getPotentialSires(ids, minAge = 1L, ped)

getPotentialSires(ids, minAge = 1L, ped)
}
\arguments{
\item{ids}{character vector of IDs of the animals}

\item{minAge}{integer value indicating the minimum age to consider in group
formation. Pairwise kinships involving an animal of this age or younger will
be ignored. Default is 1 year.}

\item{ped}{dataframe that is the \code{Pedigree}. It contains pedigree
information including the IDs listed in \code{candidates}.}
}
\value{
A character vector of potential sire Ids

A character vector of potential sire Ids
}
\description{
Provides list of potential sires

Provides list of potential sires
}
\examples{
library(nprcgenekeepr)
ped <- nprcgenekeepr::pedWithGenotype
ids <- nprcgenekeepr::qcBreeders
getPotentialSires(ids, minAge = 1L, ped)
library(nprcgenekeepr)
ped <- nprcgenekeepr::pedWithGenotype
ids <- nprcgenekeepr::qcBreeders
getPotentialSires(ids, minAge = 1, ped)
}
