% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertSexCodes.R
\name{convertSexCodes}
\alias{convertSexCodes}
\title{Converts sex indicator for an individual to a standardized codes.}
\usage{
convertSexCodes(sex, ignoreHerm = TRUE)
}
\arguments{
\item{sex}{factor with levels: "M", "F", "U". Sex specifier for an
individual.}

\item{ignoreHerm}{logical flag indicating if hermaphrodites should be
treated as unknown sex ("U"), default is \code{TRUE}.}
}
\value{
A vector of factors representing standardized sex codes after
transformation from non-standard codes.
}
\description{
Part of Pedigree Curation
}
\details{
Standard sex codes are
\itemize{
\item\{F\} \{-- replacing "FEMALE" or "2"\}
\item\{M\} \{-- replacing "MALE" or "1"\}
\item\{H\} \{-- replacing "HERMAPHRODITE" or "4", if ignore.herm == FALSE\}
\item\{U\} \{-- replacing "HERMAPHRODITE" or "4", if ignore.herm == TRUE\}
\item\{U\} \{-- replacing "UNKNOWN" or "3"\}}
}
\examples{
library(nprcgenekeepr)
original <- c(
  "m", "male", "1", "MALE", "M", "F", "f", "female",
  "FemAle", "U", "Unknown", "H", "hermaphrodite",
  "U", "Unknown", "3", "4"
)
sexCodes <- convertSexCodes(original)
sexCodes
}
