% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hasBothParents.R
\name{hasBothParents}
\alias{hasBothParents}
\title{hasBothParents checks to see if both parents are identified.}
\usage{
hasBothParents(id, ped)
}
\arguments{
\item{id}{character vector of IDs to examine for parents}

\item{ped}{a pedigree}
}
\value{
TRUE if ID has both sire and dam identified in \code{ped}.
}
\description{
hasBothParents checks to see if both parents are identified.
}
\examples{
library(nprcgenekeepr)
ped <- nprcgenekeepr::pedOne
names(ped) <- c("id", "sire", "dam", "sex", "birth")
hasBothParents("o2", ped)
ped$sire[ped$id == "o2"] <- NA
hasBothParents("o2", ped)
}
